import 'dart:convert';
import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:intl/intl.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/DialogHelper.dart';
import '../../../Networking/getAuthHeaders.dart';

class HospitalNotificationScreen extends StatefulWidget {
  const HospitalNotificationScreen({super.key});

  @override
  State<HospitalNotificationScreen> createState() => _HospitalNotificationScreenState();
}

class _HospitalNotificationScreenState extends State<HospitalNotificationScreen> {
  @override
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="";
  List<Notification> notification = [];
  @override
  void initState() {
    super.initState();
    SystemChrome.setSystemUIOverlayStyle(SystemUiOverlayStyle(
      statusBarColor: Color(0xff004D40), // or any color
      statusBarIconBrightness: Brightness.light,
    ));
    initialeclass();
  }
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    Firstname = sharedPreferences.getString("username") ?? '';
    USERID = sharedPreferences.getString("user_id") ?? '';
    ROLEID = sharedPreferences.getString("userRole") ?? '';
    // ROLENAME = sharedPreferences.getString("role_name") ?? '';
    Filesapi();
  }
  Filesapi()async {
    try {
      DialogHelper.showLoading(context);
      final headers = await getAuthHeaders();

      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.NOTIFICATION + "/"+USERID), headers: headers);
      print(apiService.BaseURL + apiService.NOTIFICATION + "/"+USERID);
      if (response.statusCode == 200) {
        DialogHelper.dismissDialog();
        final Map<String, dynamic> jsonResponse = json.decode(response.body);
        final List<dynamic> responseData = jsonResponse['data'];

        setState(() {
          notification = responseData.map((fileJson) => Notification.fromJson(fileJson)).toList();
        });



      } else {
        DialogHelper.dismissDialog();
        throw Exception('Failed to load Images');
      }
    } on SocketException {
      DialogHelper.dismissDialog();
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch ');
    }  catch (e) {
      print(e);
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Stack(
        children: [
          Container(
            height: 150,
            decoration: BoxDecoration(
              color: Color(0xff004D40), // Example background color
              borderRadius: BorderRadius.only(
                bottomLeft: Radius.circular(20.0),
                bottomRight: Radius.circular(20.0),
              ),
            ), // Example background color
          ),
          Padding(
            padding: const EdgeInsets.only(left: 5.0, right: 10.0, top: 100.0, bottom: 0.0),
            child: notification.isEmpty
                ? Center(child: Text("No Notification  Found",style: TextStyle(
              color: Colors.black,
              fontSize: 20, // You can adjust the font size as needed
              fontWeight: FontWeight.bold, // Optional: Make the text bold
            ),)) // Show loading if no files are available
                : ListView.builder(
              itemCount: notification.length,
              itemBuilder: (context, index) {
                final notifications = notification[index];
                return
                  Card(child:
                  Padding(
                    padding: const EdgeInsets.only(left: 15.0,right: 15.0),
                    child: Container(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Padding(
                              padding: const EdgeInsets.all(2.0),
                              child: Align(
                                alignment: Alignment.topRight,
                                child: Text(
                                  notifications.createdAt != null
                                      ? DateFormat('dd-MM-yyyy').format(
                                      DateTime.parse(notifications.createdAt!)
                                          .toUtc() // Convert to UTC
                                          .add(Duration(hours: 5, minutes: 30)) // Add 5 hours 30 minutes to convert to IST
                                  )
                                      : '',
                                  style: TextStyle(color: Colors.grey),
                                ),
                              ),
                            ),

                            Text(   notifications.title ?? '',style: TextStyle(fontWeight: FontWeight.bold,fontSize: 18),),
                            Padding(
                              padding: const EdgeInsets.only(left: 5.0,right: 5.0),
                              child: Divider(
                                  color: Colors.grey
                              ),
                            ),
                            Text(notifications.message ?? '',style: TextStyle(fontSize: 16)),
                            Padding(
                              padding: const EdgeInsets.all(2.0),
                              child: Align(
                                alignment: Alignment.topRight,
                                child: Text(
                                  notifications.createdAt != null
                                      ? DateFormat('hh:mm a').format(
                                      DateTime.parse(notifications.createdAt!)
                                          .toUtc()
                                          .add(Duration(hours: 5, minutes: 30))
                                  )
                                      : '',
                                  style: TextStyle(color: Colors.grey),
                                ),
                              ),
                            ),


                          ],
                        )),
                  ));
              },
            ),
          ),
        ],
      ),
    );
  }

}

class Notification {
  Notification({
    required this.id,
    required this.title,
    required this.message,
    required this.userId,
    required this.isRead,
    required this.createdAt,
    required this.updatedAt,
  });

  final int? id;
  final String? title;
  final String? message;
  final String? userId;
  final int? isRead;
  final String? createdAt;
  final String? updatedAt;

  factory Notification.fromJson(Map<String, dynamic> json){
    return Notification(
      id: json["id"],
      title: json["title"],
      message: json["message"],
      userId: json["user_id"],
      isRead: json["is_read"],
      createdAt:json["created_at"] ,
      updatedAt: json["updated_at"] ,
    );
  }

}