import 'dart:convert';
import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/DialogHelper.dart';
import '../../../Networking/getAuthHeaders.dart';
import '../../LoginScreen.dart';

class AdminProfileScreen extends StatefulWidget {
  const AdminProfileScreen({super.key});

  @override
  State<AdminProfileScreen> createState() => _AdminProfileScreenState();
}

class _AdminProfileScreenState extends State<AdminProfileScreen> {

  String profile_pic="";
  final TextEditingController nameController = TextEditingController();
  final TextEditingController emailController = TextEditingController();
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="",Pendingfile="",Recivedfile="";
  String Name="",Role="",Hospital="",Mobile="",Password="";
  @override
  void initState() {
    super.initState();

    initialeclass();
  }
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    Firstname = sharedPreferences.getString("username") ?? '';
    USERID = sharedPreferences.getString("user_id") ?? '';
    ROLEID = sharedPreferences.getString("userRole") ?? '';
    // ROLENAME = sharedPreferences.getString("role_name") ?? '';
    Profileapi(USERID);
  }
  Profileapi(String userid)async {

    DialogHelper.showLoading(context);
    try {
      final headers = await getAuthHeaders();
      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.PROFILE + "/"+USERID),headers: headers);
      print(apiService.BaseURL + apiService.PROFILE + "/"+USERID);
      if (response.statusCode == 200) {
        DialogHelper.dismissDialog();
        // Decode the JSON into a Map
        final Map<String, dynamic> jsonMap = jsonDecode(response.body);

        final data = jsonMap['data'];


        print("Full Data: $data");




        // Update state with profile data
        setState(() {
          profile_pic = data['profile'] ?? '';  // Profile image URL
          nameController.text = data['name'] ?? '';  // Name field
          emailController.text = data['email'] ?? '';
          Hospital = data['hospital_name'] ?? '';
          Role = data['role_name'] ?? '';
          Mobile= data['mobile'] ?? '';

          print("profile"+profile_pic);
          // Email field
        });



      } else {
        Fluttertoast.showToast(
          msg: "Failed to load Data.",
          toastLength: Toast.LENGTH_SHORT,
          gravity: ToastGravity.BOTTOM,
          backgroundColor: Colors.red,
          textColor: Colors.white,
        );
        DialogHelper.dismissDialog();
        throw Exception('Failed to load Images');
      }
    } on SocketException {
      DialogHelper.dismissDialog();
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch ');
    }  catch (e) {
      print(e);
    }
  }


  @override
  Widget build(BuildContext context) {

    return
      Scaffold(

        backgroundColor: Colors.white,
        body: Stack(

          children: [
            Container(
              height: 150,
              decoration: BoxDecoration(
                color: Color(0xffF2903E), // Example background color
                borderRadius: BorderRadius.only(
                  bottomLeft: Radius.circular(20.0),
                  bottomRight: Radius.circular(20.0),
                ),
              ), // Example background color
            ),
            SingleChildScrollView(
              child: Center(
                child: Padding(
                  padding: const EdgeInsets.only(left: 5.0, right: 10.0, top: 20.0, bottom: 0.0),
                  child: Padding(
                    padding: const EdgeInsets.all(10.0),
                    child:
                    Column(
                      children: [

                        Center(
                          child: CircleAvatar(
                            radius: 70,
                            backgroundColor: Colors.white,
                            child: ClipOval(
                              child: (profile_pic == null || profile_pic!.isEmpty)
                                  ? Icon(
                                Icons.account_circle_rounded,
                                size: 130,
                                color: Colors.grey,
                              )
                                  : Image.network(
                                profile_pic!,
                                width: 130,
                                height: 130,
                                fit: BoxFit.cover,
                                loadingBuilder: (context, child, loadingProgress) {
                                  if (loadingProgress == null) return child;
                                  return Center(
                                    child: CircularProgressIndicator(),
                                  );
                                },
                                errorBuilder: (context, error, stackTrace) => Center(
                                  child: Icon(
                                    Icons.error,
                                    size: 130,
                                    color: Colors.red,
                                  ),
                                ),
                              ),
                            ),
                          ),
                        )
                        ,

                        Container(


                          child: Card(
                            elevation: 10,
                            child: Column(
                              children: [
                                SizedBox(height: 10,),
                                _buildInfoRow(
                                  Icon(
                                    Icons.manage_accounts,
                                    size: 30,
                                    color: Colors.black,
                                  ),
                                  nameController.text,
                                ),
                                _buildInfoRow(
                                  Icon(
                                    Icons.filter_tilt_shift,
                                    size: 30,
                                    color: Colors.black,
                                  ),
                                  "",
                                ),
                                _buildInfoRow(
                                  Icon(
                                    Icons.location_on,
                                    size: 30,
                                    color: Colors.black,
                                  ),
                                  "",
                                ),
                                _buildInfoRow(
                                  Icon(
                                    Icons.call,
                                    size: 30,
                                    color: Colors.black,
                                  ),
                                  "",
                                ),
                                _buildInfoRow(
                                  Icon(
                                    Icons.mail,
                                    size: 30,
                                    color: Colors.black,
                                  ),
                                 "",
                                ),
                                SizedBox(height: 10,),
                              ],
                            ),
                          ),
                        ),




                        Padding(
                          padding: const EdgeInsets.only(top: 20.0,bottom: 20.0,left: 40.0,right: 40.0),
                          child: ElevatedButton(
                            style: ElevatedButton.styleFrom(
                              minimumSize: Size.fromHeight(50),
                              backgroundColor: Color(0xffF2903E),
                              shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(5.0),
                              ),// fromHeight use double.infinity as width and 40 is the height
                            ),
                            onPressed: () async {
                              SharedPreferences prefs = await SharedPreferences.getInstance();
                              prefs.setBool('isLoggedIn', false);
                              Navigator.of(context).pushReplacement(MaterialPageRoute(
                                  builder: (context) => LoginScreen()));

                            },
                            child: Text('LOGOUT',style: TextStyle(color: Colors.white),),
                          ),
                        )

                      ],
                    ),

                  ),
                ),
              ),
            )
          ],
        ),
      );
  }

  Widget _buildInfoRow(Icon icon, String text) {
    return Container(
      padding: EdgeInsets.all(10),
      margin: EdgeInsets.symmetric(vertical: 5, horizontal: 10),
      decoration: BoxDecoration(
        border: Border.all(color: Colors.black, width: 2),
        borderRadius: BorderRadius.circular(12),
      ),
      child: Row(
        children: [
          icon,
          SizedBox(width: 15),
          Expanded(
            child: Text(
              text,
              style: TextStyle(
                fontSize: 15,
                color: Colors.black87,
                fontWeight: FontWeight.w500,
              ),
            ),
          ),
        ],
      ),
    );
  }



}
