import 'dart:convert';
import 'dart:io';

import 'package:capscribes/UI/Admin/dashboard/AdduserPage.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:search_choices/search_choices.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/getAuthHeaders.dart';

class AdminHomeScreen extends StatefulWidget {
  const AdminHomeScreen({super.key});

  @override
  State<AdminHomeScreen> createState() => _AdminHomeScreenState();
}

class _AdminHomeScreenState extends State<AdminHomeScreen> {

  int _selectedToggleIndex = 0,selectedIndex=0;
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="",Pendingfile="",Recivedfile="",Doctorid="",selectdoctor="",selecthospital="";
  int  Totalfiles=0;
  Future<List<Map<String, dynamic>>>? _doctorFuture;
  Future<List<Map<String, dynamic>>>? _hospitalFuture;


  String DOCTORID="",Type="today",HOSPITALID="",HOSPITALNAME="";
  String? DOCTORNAME;
  @override
  void initState() {
    super.initState();
    initialeclass();
  }
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    Firstname = sharedPreferences.getString("username") ?? '';
    USERID = sharedPreferences.getString("user_id") ?? '';
    ROLEID = sharedPreferences.getString("userRole") ?? '';
    // ROLENAME = sharedPreferences.getString("role_name") ?? '';
    Dashboredapi(Type);
    setState(() {
      _doctorFuture = Apidoctorlist();
      _hospitalFuture=APIHOSPITALlist();// Call your API method
    });
  }

  Dashboredapi(String type) async {
    try {
      final headers = await getAuthHeaders();
      final Uri url = Uri.parse(apiService.BaseURL + apiService.Dashboredhospital).replace(
        queryParameters: {
          'difference': type,
          'doctor_id': DOCTORID,
          'hospital_id': HOSPITALID,

        },
      );

      print("GET Request URL: $url");

      final response = await http.get(
        url,
          headers: headers,
      );

      if (response.statusCode == 200) {
        print("Raw Response Body: ${response.body}");

        final Map<String, dynamic> jsonMap = jsonDecode(response.body);
        print("Decoded JSON: $jsonMap");

        setState(() {
          Totalfiles = int.parse(jsonMap['file']);
          Pendingfile = jsonMap['pending'].toString();
          Recivedfile = jsonMap['download'].toString();
        });

      } else {
        print("Response Status Code: ${response.statusCode}");
        print("Response Body: ${response.body}");
        throw Exception('Failed to load dashboard data');
      }
    } on SocketException {
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch');
    } catch (e) {
      print("Error: $e");
    }
  }


  Future<List<Map<String, dynamic>>> Apidoctorlist() async {
    try {
      final headers = await getAuthHeaders();
      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.Doctorlist + "/"+HOSPITALID),headers: headers);
      print(apiService.BaseURL + apiService.Doctorlist + "/"+HOSPITALID);

      if (response.statusCode == 200) {
        // Decode the JSON response
        final decoded = json.decode(response.body);

        // Access the list inside the "data" key
        final List<dynamic> data = decoded['data'];

        // Convert and return as List<Map<String, dynamic>>
        return List<Map<String, dynamic>>.from(data);
      } else {
        throw Exception('Failed to load doctor list');
      }
    } on SocketException {
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch');
    } catch (e) {
      print("Error: $e");
      throw Exception('An error occurred: $e');
    }
  }
  Future<List<Map<String, dynamic>>> APIHOSPITALlist() async {
    try {
      final headers = await getAuthHeaders();
      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.HOSPITALLIST ),headers: headers);
      print(apiService.BaseURL + apiService.HOSPITALLIST );

      if (response.statusCode == 200) {
        // Decode the JSON response
        final decoded = json.decode(response.body);

        // Access the list inside the "data" key
        final List<dynamic> data = decoded['hospitals'];

        // Convert and return as List<Map<String, dynamic>>
        return List<Map<String, dynamic>>.from(data);
      } else {
        throw Exception('Failed to load doctor list');
      }
    } on SocketException {
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch');
    } catch (e) {
      print("Error: $e");
      throw Exception('An error occurred: $e');
    }
  }
  void _showFabMenu(BuildContext context) async {
    final RenderBox button = context.findRenderObject() as RenderBox;
    final RenderBox overlay = Overlay.of(context).context.findRenderObject() as RenderBox;

    final RelativeRect position = RelativeRect.fromRect(
      Rect.fromPoints(
        button.localToGlobal(Offset.zero, ancestor: overlay),
        button.localToGlobal(button.size.bottomRight(Offset.zero), ancestor: overlay),
      ),
      Offset.zero & overlay.size,
    );

    final result = await showMenu<String>(
      context: context,
      position: position,
      items: [
        PopupMenuItem(
          value: "doctor",
          child: Row(
            children: const [
              Icon(Icons.medical_services, color: Colors.blue),
              SizedBox(width: 10),
              Text("Doctor"),
            ],
          ),
        ),
        PopupMenuItem(
          value: "transcript",
          child: Row(
            children: const [
              Icon(Icons.article, color: Colors.green),
              SizedBox(width: 10),
              Text("Transcript"),
            ],
          ),
        ),
        PopupMenuItem(
          value: "quality",
          child: Row(
            children: const [
              Icon(Icons.article, color: Colors.green),
              SizedBox(width: 10),
              Text("Quality"),
            ],
          ),
        ),
        PopupMenuItem(
          value: "hospital",
          child: Row(
            children: const [
              Icon(Icons.local_hospital, color: Colors.red),
              SizedBox(width: 10),
              Text("Hospital"),
            ],
          ),
        ),
      ],
    );

    if (result != null) {


      Navigator.push(context, MaterialPageRoute(
        builder: (context) => AdduserPage(
          result: result,

        ),
      ));



    }

  }
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: const Color(0xffC85D06),
      body: SafeArea(
        child: SingleChildScrollView(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              const SizedBox(height: 20),
              Padding(
                padding: const EdgeInsets.only(left: 20.0),
                child:  Text.rich(
                  TextSpan(
                    text: "Welcome ",
                    style: TextStyle(fontSize: 24, color: Colors.white),
                    children: [
                      TextSpan(
                        text: Firstname,
                        style: TextStyle(fontWeight: FontWeight.bold),
                      ),
                    ],
                  ),
                ),
              ),
              const SizedBox(height: 10),
              Padding(
                padding: const EdgeInsets.all(8.0),
                child: Container(
                  child: Column(
                    children: [
                      Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 10),
                        child: Card(
                          elevation: 5,
                          child: Container(
                            padding: const EdgeInsets.all(20),
                            child: Column(
                              children: [
                                SvgPicture.asset(
                                  'assets/loginlogo.svg',
                                  fit: BoxFit.fitWidth,
                                ),
                                Container(
                                  padding: const EdgeInsets.all(4),
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(20),
                                    color: Colors.grey[200],
                                  ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                                    children: [
                                      buildToggle("Today", _selectedToggleIndex == 0, () {
                                        setState(() {
                                          _selectedToggleIndex = 0;
                                          Type = "today";
                                          Dashboredapi(Type);
                                        });
                                      }),
                                      buildToggle("Weekly", _selectedToggleIndex == 1, () {
                                        setState(() {
                                          _selectedToggleIndex = 1;
                                          Type = "weekly";
                                          Dashboredapi(Type);
                                        });
                                      }),
                                      buildToggle("Monthly", _selectedToggleIndex == 2, () {
                                        setState(() {
                                          _selectedToggleIndex = 2;
                                          Type = "monthly";
                                          Dashboredapi(Type);
                                        });
                                      }),
                                    ],

                                  ),
                                ),

                                const SizedBox(height: 5),
                                const Text(
                                  "",
                                  style: TextStyle(
                                      fontSize: 20,
                                      fontWeight: FontWeight.bold,
                                      color: Color(0xffFF9C4B)),
                                ),
                                const SizedBox(height: 5),
                                CircularFileIndicator(
                                  totalFiles: 10000,
                                  completedFiles:Totalfiles,
                                ),
                                buildStatusRow(Pendingfile,Recivedfile),
                              ],
                            ),
                          ),
                        ),
                      ),

                      Column(
                        children: [
                          Padding(
                            padding: const EdgeInsets.only(left: 15.0, right: 15.0),
                            child: Row(
                              children: [
                                // Left button (rounded on the left side)
                                Expanded(
                                  child: GestureDetector(
                                    onTap: () {
                                      setState(() {
                                        selectedIndex = 0;
                                      });
                                    },
                                    child: AnimatedContainer(
                                      duration: Duration(milliseconds: 200),
                                      decoration: BoxDecoration(
                                        color: Color(0xffFF9C4B),
                                        borderRadius: BorderRadius.only(
                                          topLeft: Radius.circular(12),
                                          bottomLeft: Radius.circular(12),
                                        ),
                                      ),
                                      alignment: Alignment.center,
                                      child: SizedBox(
                                        height: 70,
                                        child: Padding(
                                          padding: const EdgeInsets.symmetric(vertical: 8, horizontal: 12), // Added horizontal padding
                                          child: FutureBuilder<List<Map<String, dynamic>>>( // Doctor dropdown
                                            future: _doctorFuture,
                                            builder: (context, snapshot) {
                                              if (snapshot.connectionState == ConnectionState.waiting) {
                                                return Center(child: SizedBox(height: 20, width: 20, child: CircularProgressIndicator()));
                                              } else if (snapshot.hasError || !snapshot.hasData) {
                                                return Center(child: Text('No Doctor Found', style: TextStyle(color: Colors.white)));
                                              } else {
                                                return SearchChoices.single(

                                                  padding: EdgeInsets.zero,
                                                  items: snapshot.data!
                                                      .map<DropdownMenuItem<String>>((item) {
                                                    return DropdownMenuItem<String>(
                                                      value: '${item['name']},${item['id']}',
                                                      child: Text(
                                                        item['name'] + " (" + item['hospital_name'] + ")",
                                                        style: TextStyle(fontSize: 14),
                                                      ),
                                                    );
                                                  })
                                                      .toList(),
                                                  value: selectdoctor,
                                                  hint: Text(
                                                    "Select Doctor",
                                                    style: TextStyle(color: Colors.white70, fontSize: 14, fontWeight: FontWeight.bold),
                                                  ),
                                                  searchHint: "Select Doctor",
                                                  underline: Container(),
                                                  icon: SizedBox.shrink(),
                                                  onChanged: (newValue) {
                                                    setState(() {
                                                      selectdoctor = newValue as String;
                                                      List<String> parts = newValue.split(',');
                                                      DOCTORID = parts[1];
                                                      DOCTORNAME = parts[0];
                                                      Dashboredapi(Type);
                                                    });
                                                  },
                                                  closeButton: "close",
                                                  isExpanded: true,
                                                  displayClearIcon: false,
                                                  style: TextStyle(color: Colors.white),
                                                  dialogBox: true,
                                                );
                                              }
                                            },
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),

                                SizedBox(width: 2.0,),

                                // Right button (rounded on the right side)
                                Expanded(
                                  child: GestureDetector(
                                    onTap: () {
                                      setState(() {
                                        selectedIndex = 1;
                                      });
                                    },
                                    child: AnimatedContainer(
                                      duration: Duration(milliseconds: 200),
                                      decoration: BoxDecoration(
                                        color:  Color(0xffFF9C4B) ,
                                        borderRadius: BorderRadius.only(
                                          topRight: Radius.circular(12),
                                          bottomRight: Radius.circular(12),
                                        ),
                                      ),
                                      alignment: Alignment.center,
                                      child: SizedBox(
                                        height: 70,
                                        child: Padding(
                                          padding: const EdgeInsets.symmetric(vertical: 8, horizontal: 12), // Padding
                                          child: FutureBuilder<List<Map<String, dynamic>>>( // Hospital dropdown
                                            future: _hospitalFuture,
                                            builder: (context, snapshot) {
                                              if (snapshot.connectionState == ConnectionState.waiting) {
                                                return Center(child: SizedBox(height: 20, width: 20, child: CircularProgressIndicator()));
                                              } else if (snapshot.hasError || !snapshot.hasData) {
                                                return Center(child: Text('No Hospital Found', style: TextStyle(color: Colors.white)));
                                              } else {
                                                return SearchChoices.single(
                                                  padding: EdgeInsets.zero,
                                                  items: snapshot.data!
                                                      .map<DropdownMenuItem<String>>((item) {
                                                    return DropdownMenuItem<String>(
                                                      value: '${item['hospital_name']},${item['userId']}',
                                                      child: Text(
                                                        item['hospital_name'],
                                                        style: TextStyle(fontSize: 14),
                                                      ),
                                                    );
                                                  })
                                                      .toList(),
                                                  value: selecthospital,
                                                  hint: Text(
                                                    "Select Hospital",
                                                    style: TextStyle(color: Colors.white70, fontSize: 14, fontWeight: FontWeight.bold),
                                                  ),
                                                  searchHint: "Select Hospital",
                                                  underline: Container(),
                                                  icon: SizedBox.shrink(),
                                                  onChanged: (newValue) {
                                                    setState(() {
                                                      selecthospital = newValue as String;
                                                      List<String> parts = newValue.split(',');
                                                      HOSPITALID = parts[1];
                                                      HOSPITALNAME = parts[0];
                                                      selectdoctor = "";
                                                      DOCTORID="";
                                                      Dashboredapi(Type);
                                                      _doctorFuture = Apidoctorlist();
                                                    });
                                                  },
                                                  closeButton: "close",
                                                  isExpanded: true,
                                                  displayClearIcon: false,
                                                  style: TextStyle(color: Colors.white),
                                                  dialogBox: true,
                                                );
                                              }
                                            },
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                          SizedBox(height: 10),
                        ],
                      )


                      // Tab-like Buttons
                      // Container(
                      //   margin: EdgeInsets.only(left: 16.0,right: 16.0),
                      //   height: 40,
                      //   decoration: BoxDecoration(
                      //     color: Colors.grey[200],
                      //     borderRadius: BorderRadius.circular(10),
                      //   ),
                      //   child: Row(
                      //     children: [
                      //        _buildTabButton("Sort By Doctor", 0),
                      //        _buildTabButton("Filter Hospital", 1),
                      //     ],
                      //   ),
                      // ),
                    ],
                  ),
                ),
              ),
            ],
          ),

        ),
      ),
      floatingActionButton: Builder(
        builder: (context) => FloatingActionButton.extended(
          onPressed: () => _showFabMenu(context),
          icon: const Icon(Icons.add),
          label: const Text("Add"), // 👈 FAB with name
        ),
      ),

    );
  }
  // Widget _buildTabButton(String label, int index) {
  //   bool isActive = selectedIndex == index;
  //
  //   return Expanded(
  //     child: GestureDetector(
  //       onTap: () {
  //         setState(() {
  //           selectedIndex = index;
  //         });
  //       },
  //       child: ClipPath(
  //         clipper: index == 0 ? RightCutClipper() : LeftCutClipper(),
  //         child: AnimatedContainer(
  //           duration: Duration(milliseconds: 200),
  //           decoration: BoxDecoration(
  //             color: isActive ? Color(0xffFF9C4B) : Colors.transparent,
  //           ),
  //           alignment: Alignment.center,
  //           height: 40,
  //           child: Text(
  //             label,
  //             style: TextStyle(
  //               color: isActive ? Colors.white : Colors.black,
  //               fontWeight: FontWeight.bold,
  //             ),
  //           ),
  //         ),
  //       ),
  //     ),
  //   );
  // }

  Widget buildStatusRow(String pending,String recived) {
    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: 30.0, vertical: 5),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Column(
            children:   [
              Icon(Icons.volume_up, color: Color(0xFF2D6DA7), size: 30),
              SizedBox(height: 6),
              Text(
                pending,
                style: TextStyle(
                  fontSize: 18,
                  fontWeight: FontWeight.bold,
                  color: Colors.red,
                ),
              ),
              Text(
                "Pending",
                style: TextStyle(fontSize: 12, color: Colors.black),
              ),
            ],
          ),
          Column(
            children:   [
              Icon(Icons.download, color: Color(0xFF2D6DA7), size: 30),
              SizedBox(height: 6),
              Text(
                recived,
                style: TextStyle(
                  fontSize: 18,
                  fontWeight: FontWeight.bold,
                  color: Colors.green,
                ),
              ),
              Text(
                "Received",
                style: TextStyle(fontSize: 12, color: Colors.black),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
Widget buildToggle(String text, bool isActive, VoidCallback onTap) {
  return GestureDetector(
    onTap: onTap,
    child: Container(
      padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 8),
      decoration: BoxDecoration(
        color: isActive ? Color(0xffFF9C4B) : Colors.transparent,
        borderRadius: BorderRadius.circular(16),
      ),
      child: Text(
        text,
        style: TextStyle(color: isActive ? Colors.white : Colors.black),
      ),
    ),
  );
}

class RightCutClipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) {
    Path path = Path();
    const double cutSize = 12;

    path.moveTo(0, 0);
    path.lineTo(size.width - cutSize, 0);
    path.lineTo(size.width, size.height / 2);
    path.lineTo(size.width - cutSize, size.height);
    path.lineTo(0, size.height);
    path.close();
    return path;
  }

  @override
  bool shouldReclip(CustomClipper<Path> oldClipper) => false;
}
class LeftCutClipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) {
    Path path = Path();
    const double cutSize = 12;

    path.moveTo(cutSize, 0);
    path.lineTo(size.width, 0);
    path.lineTo(size.width, size.height);
    path.lineTo(cutSize, size.height);
    path.lineTo(0, size.height / 2);
    path.close();
    return path;
  }

  @override
  bool shouldReclip(CustomClipper<Path> oldClipper) => false;
}

class CircularFileIndicator extends StatelessWidget {
  final int totalFiles;
  final int completedFiles;

  const CircularFileIndicator({
    super.key,
    required this.totalFiles,
    required this.completedFiles,
  });

  @override
  Widget build(BuildContext context) {
    double progress = completedFiles / totalFiles;
    return Container(
      width: 140,
      height: 140,
      decoration: const BoxDecoration(
        shape: BoxShape.circle,
        boxShadow: [
          BoxShadow(color: Colors.black12, blurRadius: 10, spreadRadius: 2),
        ],
      ),
      child: Stack(
        alignment: Alignment.center,
        children: [
          SizedBox(
            width: 120,
            height: 120,
            child: CircularProgressIndicator(
              value: 1,
              strokeWidth: 12,
              valueColor: AlwaysStoppedAnimation<Color>(Colors.grey.shade400),
            ),
          ),
          SizedBox(
            width: 120,
            height: 120,
            child: CircularProgressIndicator(
              value: progress,
              strokeWidth: 12,
              valueColor: const AlwaysStoppedAnimation<Color>(
                Color(0xffFF9C4B),
              ),
              backgroundColor: Colors.transparent,
            ),
          ),
          Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Text(
                "$completedFiles",
                style: const TextStyle(
                  fontSize: 22,
                  fontWeight: FontWeight.bold,
                ),
              ),
              const SizedBox(height: 4),
              const Text(
                "Files",
                style: TextStyle(fontSize: 16, color: Color(0xffFF9C4B)),
              ),
            ],
          ),
        ],
      ),
    );
  }
}


