import 'dart:convert';
import 'dart:io';

import 'package:audioplayers/audioplayers.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:intl/intl.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/DialogHelper.dart';
import '../../Networking/getAuthHeaders.dart';


class TrasnscrpitFileScreen extends StatefulWidget {
  const TrasnscrpitFileScreen({super.key});

  @override
  State<TrasnscrpitFileScreen> createState() => _TrasnscrpitFileScreenState();
}

class _TrasnscrpitFileScreenState extends State<TrasnscrpitFileScreen> {
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="";

  final AudioPlayer _audioPlayer = AudioPlayer();
  bool _isPlaying = false;
  String _currentPlayingAudio = '';

  List<AudioFile> audioFiles = [];
  late DateTime selectedDate;
   String formattedDate="";
  @override
  void initState() {
    super.initState();
    initialeclass();
  }
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    Firstname = sharedPreferences.getString("username") ?? '';
    USERID = sharedPreferences.getString("user_id") ?? '';
    ROLEID = sharedPreferences.getString("userRole") ?? '';
    // ROLENAME = sharedPreferences.getString("role_name") ?? '';
    selectedDate = DateTime.now();
    setState(() {
      formattedDate = DateFormat('dd-MM-yyyy').format(selectedDate);

    });

    apicall();
  }
  apicall(){
    Filesapi();
  }
  Filesapi()async {
    try {
      DialogHelper.showLoading(context);

      final headers = await getAuthHeaders();

      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.TFILES + "/"+formattedDate),headers: headers);
      print(apiService.BaseURL + apiService.TFILES + "/"+formattedDate);
      if (response.statusCode == 200) {
        DialogHelper.dismissDialog();
        final Map<String, dynamic> jsonResponse = json.decode(response.body);
        final List<dynamic> responseData = jsonResponse['data'];

        setState(() {
          audioFiles = responseData.map((fileJson) => AudioFile.fromJson(fileJson)).toList();
        });



      } else {
        DialogHelper.dismissDialog();
        throw Exception('Failed to load Images');
      }
    } on SocketException {
      DialogHelper.dismissDialog();
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch ');
    }  catch (e) {
      print(e);
    }
  }

  void _toggleAudio(String fileUrl, String name) async {
    if (_currentPlayingAudio == name) {
      // If the same audio is clicked, pause it
      if (_isPlaying) {
        await _audioPlayer.pause();
        setState(() {
          _isPlaying = false;
        });
      }
    } else {
      // Stop the current audio and start the new one
      await _audioPlayer.stop();
      await _audioPlayer.play(UrlSource(fileUrl)); // ✅ Fix is here
      setState(() {
        _isPlaying = true;
        _currentPlayingAudio = name;
      });
    }
  }


  @override
  void dispose() {
    _audioPlayer.dispose();
    super.dispose();
  }
  Future<void> _selectDate(BuildContext context) async {
    final DateTime? picked = await showDatePicker(
      context: context,
      initialDate: selectedDate,
      firstDate: DateTime(2000),
      lastDate: DateTime.now(), // Only allow past & current dates
    );
    if (picked != null && picked != selectedDate) {
      setState(() {
        selectedDate = picked;
        formattedDate = DateFormat('dd-MM-yyyy').format(picked);
        apicall();// Update formatted date
      });
    }
  }


  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Stack(
        children: [
          Column(

            children: [
              Container(
                height: 200,
                decoration: BoxDecoration(
                  color: Color(0xffb3b300), // Example background color
                  borderRadius: BorderRadius.only(
                    bottomLeft: Radius.circular(20.0),
                    bottomRight: Radius.circular(20.0),
                  ),
                ),
                child: Center(
                  child: Text(
                    "Files",
                    style: TextStyle(
                      color: Colors.white,
                      fontSize: 25, // You can adjust the font size as needed
                      fontWeight: FontWeight.bold, // Optional: Make the text bold
                    ),
                  ),
                ),
              ),




            ],
          ),
          Align(
            alignment: Alignment.topCenter,
            child: Padding(
              padding: const EdgeInsets.only(left: 5.0, right: 10.0, top: 120.0, bottom: 0.0),
              child: ElevatedButton.icon(
                onPressed: () => _selectDate(context),
                icon: Icon(Icons.date_range),
                label: Text(
                    formattedDate
                ),
                style: ElevatedButton.styleFrom(
                  elevation: 0,
                  backgroundColor: Colors.transparent,
                  foregroundColor: Colors.white,
                  side: BorderSide(color: Colors.white),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(8),
                  ),
                ),
              ),
            ),
          ),
          Padding(
            padding: const EdgeInsets.only(left: 5.0, right: 10.0, top: 140.0, bottom: 0.0),
            child: audioFiles.isEmpty
                ? Center(child: Text("No Files Found",style: TextStyle(
              color: Colors.black,
              fontSize: 20, // You can adjust the font size as needed
              fontWeight: FontWeight.bold, // Optional: Make the text bold
            ),)) // Show loading if no files are available
                : ListView.builder(
              itemCount: audioFiles.length,
              itemBuilder: (context, index) {
                final audio = audioFiles[index];
                return Card(
                  elevation: 4,
                  margin: EdgeInsets.all(4),
                  child: Padding(
                    padding: const EdgeInsets.all(6.0),
                    child: IntrinsicHeight(
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          SvgPicture.asset(
                            'assets/wave.svg',
                            height: 60,
                            fit: BoxFit.contain,
                          ),

                          const SizedBox(width: 6),

                          // Wrap the text in Expanded to allow wrapping
                          Expanded(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisSize: MainAxisSize.min,
                              children: [
                                Text(
                                  audio.fileName ?? '',
                                  style: TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
                                  overflow: TextOverflow.ellipsis,
                                  maxLines: 10,
                                ),
                                Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Row(
                                    children: [
                                      SvgPicture.asset(
                                        'assets/doctors.svg',
                                        height: 30,
                                        fit: BoxFit.contain,
                                      ),

                                      Text(
                                        "  Dr: "+audio.doctorname ?? '',
                                        style: TextStyle( fontSize: 14,color: CupertinoColors.systemBlue),
                                        overflow: TextOverflow.ellipsis,
                                        maxLines: 2,
                                      ),
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ),

                          VerticalDivider(
                            color: Colors.grey,
                            thickness: 0.5,
                            width: 10,
                          ),

                          IconButton(
                            icon: Icon(
                              _currentPlayingAudio == audio.fileName && _isPlaying
                                  ? Icons.pause_circle_outline_outlined
                                  : Icons.play_circle_outline_outlined,
                              color: Color(0xff1F5C93),
                              size: 40,
                            ),
                            onPressed: () {
                              _toggleAudio(audio.audioPath, audio.fileName);
                            },
                          ),

                          VerticalDivider(
                            color: Colors.grey,
                            thickness: 0.5,
                            width: 10,
                          ),

                          IconButton(
                            icon: SvgPicture.asset(
                              audio.description == null || audio.description.isEmpty
                                  ? 'assets/filered.svg'
                                  : 'assets/fileblue.svg',
                              height: 30,
                              width: 30,
                            ),
                            onPressed: () {
                              if (audio.description == null || audio.description.isEmpty) {
                                Fluttertoast.showToast(
                                  msg: "No Transcription Found",
                                  toastLength: Toast.LENGTH_SHORT,
                                  gravity: ToastGravity.BOTTOM,
                                  backgroundColor: Colors.red,
                                  textColor: Colors.white,
                                );
                              } else {
                                _showDescriptionDialog(audio.description);
                              }
                            },
                          ),
                        ],
                      ),
                    ),

                  ),
                );
              },
            ),
          ),
        ],
      ),
    );
  }
  void _showDescriptionDialog(String? description) {
    showModalBottomSheet(
      context: context,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.vertical(top: Radius.circular(20)),
      ),
      isScrollControlled: true,
      builder: (BuildContext context) {
        return DraggableScrollableSheet(
          expand: false,
          initialChildSize: 0.5,
          minChildSize: 0.3,
          maxChildSize: 0.9,
          builder: (_, controller) => Stack(
            children: [
              Padding(
                padding: const EdgeInsets.fromLTRB(16, 40, 16, 32),
                child: SingleChildScrollView(
                  controller: controller,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      const Text(
                        'Description',
                        style: TextStyle(fontSize: 18, fontWeight: FontWeight.bold),
                      ),
                      const Divider(),
                      const SizedBox(height: 8),
                      Text(
                        (description == null || description.trim().isEmpty)
                            ? "No description found"
                            : description,
                        style: const TextStyle(fontSize: 16),
                      ),
                      const SizedBox(height: 16),
                    ],
                  ),
                ),
              ),
              Positioned(
                top: 8,
                right: 8,
                child: IconButton(
                  icon: const Icon(Icons.close),
                  onPressed: () => Navigator.of(context).pop(),
                ),
              ),
            ],
          ),
        );
      },
    );
  }


}

class AudioFile {
  final String audioPath;
  final String fileName;
  final String description;
  final String doctorname;

  AudioFile({
    required this.audioPath,
    required this.fileName,
    required this.description,
    required this.doctorname,
  });

  factory AudioFile.fromJson(Map<String, dynamic> json) {
    return AudioFile(
      audioPath: json['audio_path'] ?? '',
      fileName: json['file_name'] ?? '',
      description: json['transcription'] ?? '',
      doctorname: json['doctor_name'] ?? '',
    );
  }
}