import 'dart:convert';
import 'dart:io';

import 'package:audioplayers/audioplayers.dart';
import 'package:capscribes/UI/Admin/dashboard/AdminAllDoctorListsScreen.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/DialogHelper.dart';
import '../../../Networking/getAuthHeaders.dart';
import 'AllDoctorListsScreen.dart';

class SelectedDoctorFileScreen extends StatefulWidget {
  final String DoctorID,DoctorName;
  const SelectedDoctorFileScreen({super.key, required this.DoctorID,required this.DoctorName});

  @override
  State<SelectedDoctorFileScreen> createState() => _SelectedDoctorFileScreenState();
}

class _SelectedDoctorFileScreenState extends State<SelectedDoctorFileScreen> {
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="";

  final AudioPlayer _audioPlayer = AudioPlayer();
  bool _isPlaying = false;
  String _currentPlayingAudio = '';

  List<AudioFile> audioFiles = [];

  @override
  void initState() {
    super.initState();
    initialeclass();
  }
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    Firstname = sharedPreferences.getString("username") ?? '';
    USERID = sharedPreferences.getString("user_id") ?? '';


    setState(() {
      ROLEID = sharedPreferences.getString("userRole") ?? '';
      Filesapi();
    });
    // ROLENAME = sharedPreferences.getString("role_name") ?? '';

  }

  Filesapi()async {
    try {
      DialogHelper.showLoading(context);
      final headers = await getAuthHeaders();

      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.FILES + "/"+widget.DoctorID), headers: headers);
      print(apiService.BaseURL + apiService.FILES + "/"+widget.DoctorID);
      if (response.statusCode == 200) {
        DialogHelper.dismissDialog();
        final Map<String, dynamic> jsonResponse = json.decode(response.body);
        final List<dynamic> responseData = jsonResponse['data'];

        setState(() {
          audioFiles = responseData.map((fileJson) => AudioFile.fromJson(fileJson)).toList();
        });



      } else {
        DialogHelper.dismissDialog();
        throw Exception('Failed to load Images');
      }
    } on SocketException {
      DialogHelper.dismissDialog();
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch ');
    }  catch (e) {
      print(e);
    }
  }

  void _toggleAudio(String fileUrl, String name) async {
    if (_currentPlayingAudio == name) {
      // If the same audio is clicked, pause it
      if (_isPlaying) {
        await _audioPlayer.pause();
        setState(() {
          _isPlaying = false;
        });
      }
    } else {
      // Stop the current audio and start the new one
      await _audioPlayer.stop();
      await _audioPlayer.play(UrlSource(fileUrl)); // ✅ Fix is here
      setState(() {
        _isPlaying = true;
        _currentPlayingAudio = name;
      });
    }
  }

  Color getBackgroundColor(String roleId) {
    switch (roleId) {
      case "2": // Admin
        return Color(0xffF2903E);
      case "4": // Doctor
        return Color(0xff1F5C93); // Greenish
      case "5": // Hospital
        return Color(0xff004D40); // Purple
      default:
        return Colors.grey; // Default or unknown
    }
  }

  @override
  void dispose() {
    _audioPlayer.dispose();
    super.dispose();
  }
  Color getRoleColor(String roleId) {
    switch (roleId) {
      case "2": // Admin
        return Color(0xffF2903E);
      case "4": // Doctor
        return Color(0xff1F5C93);
      case "5": // Hospital
        return Color(0xff004D40);
      default:
        return Colors.grey;
    }
  }
  @override
  Widget build(BuildContext context) {
    return
      PopScope(
        canPop: false, // prevent default back
        onPopInvoked: (didPop) async {
          if (!didPop) {



            switch (ROLEID) {
              case "2":
                Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(builder: (context) => AdminAllDoctorListsScreen()),
                );
                break;
              case "5":
                Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(builder: (context) => AllDoctorListsScreen()),
                );
                break;
              default:
              // Handle unknown ROLEID or do nothing
                break;
            }



          }
        },
      child: Scaffold(
        appBar: AppBar(
         backgroundColor:  getBackgroundColor(ROLEID),
          leading: IconButton(
            icon: Icon(
              Icons.arrow_back_ios_new_outlined,
              color: Colors.white,
            ),
            onPressed: () {

              switch (ROLEID) {
                case "2":
                  Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(builder: (context) => AdminAllDoctorListsScreen()),
                  );
                  break;
                case "5":
                  Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(builder: (context) => AllDoctorListsScreen()),
                  );
                  break;
                default:
                // Handle unknown ROLEID or do nothing
                  break;
              }


            },
          ),
          title: Text(widget.DoctorName, style: TextStyle(color: Colors.white)),
        ),

        backgroundColor: Colors.white,
        body: Stack(
          children: [
            Column(
              children: [
                Container(
                  height: 150,
                  decoration: BoxDecoration(
                    color:  getRoleColor(ROLEID), // Example background color
                    borderRadius: BorderRadius.only(
                      bottomLeft: Radius.circular(20.0),
                      bottomRight: Radius.circular(20.0),
                    ),
                  ),
                  child: Center(
                    child: Text(
                      "Files",
                      style: TextStyle(
                        color: Colors.white,
                        fontSize: 25, // You can adjust the font size as needed
                        fontWeight: FontWeight.bold, // Optional: Make the text bold
                      ),
                    ),
                  ),
                ),

              ],
            ),
            Padding(
              padding: const EdgeInsets.only(left: 5.0, right: 10.0, top: 100.0, bottom: 0.0),
              child: audioFiles.isEmpty
                  ? Center(child: Text("No Files Found",style: TextStyle(
                color: Colors.black,
                fontSize: 20, // You can adjust the font size as needed
                fontWeight: FontWeight.bold, // Optional: Make the text bold
              ),)) // Show loading if no files are available
                  : ListView.builder(
                itemCount: audioFiles.length,
                itemBuilder: (context, index) {
                  final audio = audioFiles[index];
                  return Card(
                    elevation: 4,
                    margin: EdgeInsets.all(4),
                    child: Padding(
                      padding: const EdgeInsets.all(6.0),
                      child: IntrinsicHeight(
                        child: Row(
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            SvgPicture.asset(
                              'assets/wave.svg',
                              height: 40,
                              fit: BoxFit.contain,
                            ),

                            const SizedBox(width: 6),
                            Expanded(
                              child: Text(
                                audio.fileName ?? '',
                                style: TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
                              ),
                            ),
                            VerticalDivider(
                              color: Colors.grey,
                              thickness: 0.5,
                              width: 10,
                            ),
                            IconButton(
                              icon: Icon(
                                _currentPlayingAudio == audio.fileName && _isPlaying
                                    ? Icons.pause_circle_outline_outlined
                                    : Icons.play_circle_outline_outlined,
                                color: Color(0xff1F5C93),
                                size: 40,
                              ),
                              onPressed: () {
                                _toggleAudio(audio.audioPath, audio.fileName);
                              },
                            ),
                            VerticalDivider(
                              color: Colors.grey,
                              thickness: 0.5,
                              width: 10,
                            ),


                      IconButton(
                      icon: SvgPicture.asset(
                      audio.description == null || audio.description.isEmpty
                      ? 'assets/filered.svg'
                          : 'assets/fileblue.svg',
                        height: 30,
                        width: 30,
                      ),
                      onPressed: () {
                        if (audio.description == null || audio.description.isEmpty) {
                          Fluttertoast.showToast(
                            msg: "No Transcription Found",
                            toastLength: Toast.LENGTH_SHORT,
                            gravity: ToastGravity.BOTTOM,
                            backgroundColor: Colors.red,
                            textColor: Colors.white,
                          );
                        } else {
                          _showDescriptionDialog(audio.description);
                        }
                      },
                    ),


      // Function to show the description in a dialog

                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            ),
          ],
        ),
      ),
    );
  }
  void _showDescriptionDialog(String? description) {
    showModalBottomSheet(
      context: context,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.vertical(top: Radius.circular(20)),
      ),
      isScrollControlled: true,
      builder: (BuildContext context) {
        return Stack(
          children: [
            Padding(
              padding: const EdgeInsets.fromLTRB(16, 40, 16, 32), // Top padding to avoid close button
              child: Column(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  const Text(
                    'Description',
                    style: TextStyle(fontSize: 18, fontWeight: FontWeight.bold),
                  ),
                  const Divider(),
                  const SizedBox(height: 8),
                  Text(
                    (description == null || description.trim().isEmpty)
                        ? "No description found"
                        : description,
                    style: const TextStyle(fontSize: 16),
                  ),
                  const SizedBox(height: 16),
                ],
              ),
            ),
            Positioned(
              top: 8,
              right: 8,
              child: IconButton(
                icon: const Icon(Icons.close),
                onPressed: () => Navigator.of(context).pop(),
              ),
            ),
          ],
        );
      },
    );
  }


}

class AudioFile {
  final String audioPath;
  final String fileName;
  final String description;

  AudioFile({
    required this.audioPath,
    required this.fileName,
    required this.description,
  });

  factory AudioFile.fromJson(Map<String, dynamic> json) {
    return AudioFile(
      audioPath: json['audio_path'] ?? '',
      fileName: json['file_name'] ?? '',
      description: json['transcription'] ?? '',
    );
  }
}

