import 'dart:convert';
import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:search_choices/search_choices.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/getAuthHeaders.dart';
import 'AddDoctorPage.dart';

class Hospitalhomescreen extends StatefulWidget {
  const Hospitalhomescreen({super.key});

  @override
  State<Hospitalhomescreen> createState() => _HospitalhomescreenState();
}

class _HospitalhomescreenState extends State<Hospitalhomescreen> {
  int _selectedToggleIndex = 0;
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="",Pendingfile="",Recivedfile="",Doctorid="",selectdoctor="";
  int  Totalfiles=0;
  Future<List<Map<String, dynamic>>>? _doctorFuture;

  String DOCTORID="",Type="today";
  String? DOCTORNAME;
  @override
  void initState() {
    super.initState();
    initialeclass();
  }
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    Firstname = sharedPreferences.getString("username") ?? '';
    USERID = sharedPreferences.getString("user_id") ?? '';
    ROLEID = sharedPreferences.getString("userRole") ?? '';
    // ROLENAME = sharedPreferences.getString("role_name") ?? '';
    Dashboredapi(Type);
    setState(() {
      _doctorFuture = Apidoctorlist(); // Call your API method
    });
  }

  Dashboredapi(String type) async {
    try {
      final headers = await getAuthHeaders();

      final Uri url = Uri.parse(apiService.BaseURL + apiService.Dashboredhospital).replace(
        queryParameters: {
          'difference': type,
          'doctor_id': DOCTORID,
          'hospital_id': USERID,
        },
      );

      print("GET Request URL: $url");

      final response = await http.get(
        url,
          headers: headers
      );

      if (response.statusCode == 200) {
        print("Raw Response Body: ${response.body}");

        final Map<String, dynamic> jsonMap = jsonDecode(response.body);
        print("Decoded JSON: $jsonMap");

        setState(() {
          Totalfiles = int.parse(jsonMap['file']);
          Pendingfile = jsonMap['pending'].toString();
          Recivedfile = jsonMap['download'].toString();
        });

      } else {
        print("Response Status Code: ${response.statusCode}");
        print("Response Body: ${response.body}");
        throw Exception('Failed to load dashboard data');
      }
    } on SocketException {
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch');
    } catch (e) {
      print("Error: $e");
    }
  }


  Future<List<Map<String, dynamic>>> Apidoctorlist() async {
    try {
      final headers = await getAuthHeaders();

      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.Doctorlist + "/"+USERID),headers: headers);
      print(apiService.BaseURL + apiService.Doctorlist + "/"+USERID);

      if (response.statusCode == 200) {
        // Decode the JSON response
        final decoded = json.decode(response.body);

        // Access the list inside the "data" key
        final List<dynamic> data = decoded['data'];

        // Convert and return as List<Map<String, dynamic>>
        return List<Map<String, dynamic>>.from(data);
      } else {
        throw Exception('Failed to load doctor list');
      }
    } on SocketException {
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch');
    } catch (e) {
      print("Error: $e");
      throw Exception('An error occurred: $e');
    }
  }
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor:  Color(0xFF3AAFA9),
      body: SafeArea(
        child: SingleChildScrollView(
          child: Column(
            children: [
               SizedBox(height: 20),
               Text.rich(
                TextSpan(
                  text: "Welcome ",
                  style: TextStyle(fontSize: 24, color: Colors.white),
                  children: [
                    TextSpan(
                      text: Firstname,
                      style: TextStyle(fontWeight: FontWeight.bold),
                    ),
                  ],
                ),
              ),
               SizedBox(height: 10),
              Padding(
                padding:  EdgeInsets.all(8.0),
                child: Container(
                  child: Stack(
                    children: [
                      Padding(
                        padding:   EdgeInsets.symmetric(horizontal: 10),
                        child: ClipPath(
                          clipper: DiagonalBottomLeftClipper(),
                          child: Container(
                            color: Colors.white,
                            padding:   EdgeInsets.all(20),
                            child: Column(
                              children: [
                                SvgPicture.asset(
                                  'assets/loginlogo.svg',
                                  fit: BoxFit.fitWidth,
                                ),
                                Container(
                                  padding:   EdgeInsets.all(4),
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(20),
                                    color: Colors.grey[200],
                                  ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                                    children: [
                                      buildToggle("Today", _selectedToggleIndex == 0, () {
                                        setState(() {
                                          _selectedToggleIndex = 0;
                                          Type = "today";
                                          Dashboredapi(Type);
                                        });
                                      }),
                                      buildToggle("Weekly", _selectedToggleIndex == 1, () {
                                        setState(() {
                                          _selectedToggleIndex = 1;
                                          Type = "weekly";
                                          Dashboredapi(Type);
                                        });
                                      }),
                                      buildToggle("Monthly", _selectedToggleIndex == 2, () {
                                        setState(() {
                                          _selectedToggleIndex = 2;
                                          Type = "monthly";
                                          Dashboredapi(Type);
                                        });
                                      }),
                                    ],

                                  ),
                                ),

                                  SizedBox(height: 5),
                                  Text(
                                  "",
                                  style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
                                ),


                                  SizedBox(height: 5),
                                CircularFileIndicator(
                                  totalFiles: 10000,
                                  completedFiles:Totalfiles,
                                ),
                                buildStatusRow(Pendingfile,Recivedfile),

                                  SizedBox(height: 30),
                              ],
                            ),
                          ),
                        ),
                      ),
                      // Bottom left sort button
                      Positioned(
                        bottom: 0,
                        left: 10,
                        child: ClipPath(
                          clipper: TopRightCutClipper(),
                          child: Material(
                            color: Color(0xff004D40),
                            child:
                            Padding(
                              padding: EdgeInsets.only(top: 0.0),
                              child: Container(
                                width: 165,

                                alignment: Alignment.center,
                                decoration: BoxDecoration(
                                  color: Color(0xff004D40),
                                  borderRadius: BorderRadius.circular(8),
                                ),
                                child: FutureBuilder<List<Map<String, dynamic>>>(
                                  future: _doctorFuture,
                                  builder: (context, snapshot) {
                                    if (snapshot.connectionState == ConnectionState.waiting) {
                                      return SizedBox(
                                          height: 45,
                                          child: Center(child: CircularProgressIndicator())
                                      );
                                    } else if (snapshot.hasError || !snapshot.hasData) {
                                      return SizedBox(
                                        height: 45,
                                        child: Center(
                                          child: Text('No Doctor Found', style: TextStyle(color: Colors.white)),
                                        ),
                                      );
                                    } else {
                                      return Padding(
                                        padding: const EdgeInsets.symmetric(horizontal: 8.0),
                                        child: SearchChoices.single(
                                          padding: EdgeInsets.zero,
                                          items: snapshot.data!
                                              .map<DropdownMenuItem<String>>((item) {
                                            return DropdownMenuItem<String>(
                                              value: '${item['name']},${item['id']}',
                                              child: Text(
                                                item['name'],
                                                style: TextStyle(fontSize: 14),
                                              ),
                                            );
                                          }).toList(),
                                          value: selectdoctor,
                                          hint: Text(
                                            "Select Doctor",
                                            style: TextStyle(color: Colors.white70, fontSize: 16,fontWeight: FontWeight.bold),
                                          ),
                                          searchHint: "Select Doctor",
                                          underline: Container(),
                                          icon: SizedBox.shrink(), // removes dropdown icon
                                          onChanged: (newValue) {
                                            setState(() {
                                              selectdoctor = newValue as String;
                                              List<String> parts = newValue.split(',');
                                              DOCTORID = parts[1];
                                              DOCTORNAME = parts[0];
                                              Dashboredapi(Type);



                                            });
                                          },
                                          closeButton: "close",
                                          isExpanded: true,
                                          displayClearIcon: false,
                                          style: TextStyle(color: Colors.white), // ✅ Selected item text color
                                          dialogBox: true, // 🟢 This avoids expanding in place
                                        ),
                                      );
                                    }
                                  },
                                ),
                              ),
                            )

                          ),
                        ),
                      ),
                      Positioned(
                        bottom: 0,
                        right: 10,
                        child:
                       Padding(
                         padding: const EdgeInsets.all(8.0),
                         child: OutlinedButton.icon(
                           icon: Icon(Icons.add_circle_outline,  color: Color(0xff004D40),size: 30,), // The leading icon of your button
                           label: Text('Add Doctor',style: TextStyle(color:Color(0xff004D40) )), // The text label following the icon
                           onPressed: () {

                             Navigator.push(context, MaterialPageRoute(
                               builder: (context) => Adddoctorpage(
                               ),
                             ));

                             // Define your navigation or action
                           },
                           style: OutlinedButton.styleFrom(
                             side: BorderSide(width: 3,  color: Color(0xff004D40),), // Define the outline's weight and color
                             shape: RoundedRectangleBorder(
                               borderRadius: BorderRadius.circular(5), // Your desired shape with round corners
                             ),
                           ),
                         )
                         ,
                       )
                      )
                    ],
                  ),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget buildStatusRow(String pending,String recived) {
    return Padding(
      padding:   EdgeInsets.symmetric(horizontal: 30.0, vertical: 10),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Column(
            children:   [
              Icon(Icons.volume_up, color: Color(0xFF2D6DA7), size: 30),
              SizedBox(height: 6),
              Text(
                pending,
                style: TextStyle(
                  fontSize: 18,
                  fontWeight: FontWeight.bold,
                  color: Colors.red,
                ),
              ),
              Text(
                "Pending",
                style: TextStyle(fontSize: 12, color: Colors.black),
              ),
            ],
          ),
          Column(
            children:   [
              Icon(Icons.download, color: Color(0xFF2D6DA7), size: 30),
              SizedBox(height: 6),
              Text(
                recived,
                style: TextStyle(
                  fontSize: 18,
                  fontWeight: FontWeight.bold,
                  color: Colors.green,
                ),
              ),
              Text(
                "Received",
                style: TextStyle(fontSize: 12, color: Colors.black),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
// Widget buildToggle(String text, {bool isActive = false}) {
//   return Container(
//     padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 8),
//     decoration: BoxDecoration(
//       color: isActive ? Colors.teal : Colors.transparent,
//       borderRadius: BorderRadius.circular(16),
//     ),
//     child: Text(
//       text,
//       style: TextStyle(color: isActive ? Colors.white : Colors.black),
//     ),
//   );
// }

Widget buildToggle(String text, bool isActive, VoidCallback onTap) {
  return GestureDetector(
    onTap: onTap,
    child: Container(
      padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 8),
      decoration: BoxDecoration(
        color: isActive ? Color(0xff2DAA9E) : Colors.transparent,
        borderRadius: BorderRadius.circular(16),
      ),
      child: Text(
        text,
        style: TextStyle(color: isActive ? Colors.white : Colors.black),
      ),
    ),
  );
}

class DiagonalBottomLeftClipper extends CustomClipper<Path> {
  @override
  @override
  Path getClip(Size size) {
    const double radius = 30;
    const double cutDepth = 50;
    const double cutStartX = 0.55;
    const double cutEndX = 0.45;

    Path path = Path();

    // Top-left corner
    path.moveTo(0, radius);
    path.quadraticBezierTo(0, 0, radius, 0);

    // Top-right corner
    path.lineTo(size.width - radius, 0);
    path.quadraticBezierTo(size.width, 0, size.width, radius);

    // Right side to bottom-right
    path.lineTo(size.width, size.height - radius);
    path.quadraticBezierTo(size.width, size.height, size.width - radius, size.height);

    // Z-shaped slant
    path.lineTo(size.width * cutStartX, size.height);
    path.lineTo(size.width * cutEndX, size.height - cutDepth);
    path.lineTo(radius, size.height - cutDepth);

    // Bottom-left corner with radius
    path.quadraticBezierTo(
      0, size.height - cutDepth,
      0, size.height - cutDepth - radius,
    );

    // Left edge back up
    path.lineTo(0, radius);

    path.close();
    return path;
  }









  @override
  bool shouldReclip(CustomClipper<Path> oldClipper) => false;
}
class CircularFileIndicator extends StatelessWidget {
  final int totalFiles;
  final int completedFiles;

  const CircularFileIndicator({
    super.key,
    required this.totalFiles,
    required this.completedFiles,
  });

  @override
  Widget build(BuildContext context) {
    double progress = completedFiles / totalFiles;
    return Container(
      width: 140,
      height: 140,
      decoration: const BoxDecoration(
        shape: BoxShape.circle,
        boxShadow: [
          BoxShadow(color: Colors.black12, blurRadius: 10, spreadRadius: 2),
        ],
      ),
      child: Stack(
        alignment: Alignment.center,
        children: [
          SizedBox(
            width: 120,
            height: 120,
            child: CircularProgressIndicator(
              value: 1,
              strokeWidth: 12,
              valueColor: AlwaysStoppedAnimation<Color>(Colors.grey.shade400),
            ),
          ),
          SizedBox(
            width: 120,
            height: 120,
            child: CircularProgressIndicator(
              value: progress,
              strokeWidth: 12,
              valueColor: const AlwaysStoppedAnimation<Color>(
                Color(0xFF2D6DA7),
              ),
              backgroundColor: Colors.transparent,
            ),
          ),
          Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Text(
                "$completedFiles",
                style: const TextStyle(
                  fontSize: 22,
                  fontWeight: FontWeight.bold,
                ),
              ),
              const SizedBox(height: 4),
              const Text(
                "Files",
                style: TextStyle(fontSize: 16, color: Colors.blueAccent),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
class TopRightCutClipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) {
    const double radius = 13;
    const double cutSize = 30; // Increased cut length/height
    const double cutHeight = 35; // Increased cut height

    Path path = Path();

    // Top-left corner (rounded)
    path.moveTo(0, radius);
    path.quadraticBezierTo(0, 0, radius, 0);

    // Top-right cut (increased size)
    path.lineTo(size.width - cutSize, 0);
    path.lineTo(size.width, cutHeight); // Increased cut height here

    // Right side - bottom-right corner
    path.lineTo(size.width, size.height - radius);
    path.quadraticBezierTo(size.width, size.height, size.width - radius, size.height);

    // Bottom-left corner
    path.lineTo(radius, size.height);
    path.quadraticBezierTo(0, size.height, 0, size.height - radius);

    path.close();
    return path;
  }

  @override
  bool shouldReclip(CustomClipper<Path> oldClipper) => false;
}

