import 'dart:convert';
import 'dart:io';

import 'package:capscribes/UI/Doctor/DoctorDashboardScreen.dart';
import 'package:capscribes/UI/Hospital/HospitalDashboardScreen.dart';
import 'package:capscribes/UI/Transcrpit/TranscrpitDashboardScreen.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:image_picker/image_picker.dart';
import 'package:permission_handler/permission_handler.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/DialogHelper.dart';
import '../../../Networking/getAuthHeaders.dart';
import '../../Admin/AdminDashboardScreen.dart';

class EditProfilePage extends StatefulWidget {
  final String name;
  final String email;
  final String mobile;
  final String profile_pic;

  EditProfilePage({
    required this.name,
    required this.email,
    required this.mobile,
    required this.profile_pic,
  });

  @override
  _EditProfilePageState createState() => _EditProfilePageState();
}

class _EditProfilePageState extends State<EditProfilePage> {
  late TextEditingController _nameController;
  late TextEditingController _emailController;
  late TextEditingController _mobileController;
  File? _profileImageFile;
  final ImagePicker _picker = ImagePicker();
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="",Pendingfile="",Recivedfile="";
  final _formKey = GlobalKey<FormState>();

  @override
  void initState() {
    super.initState();
    _nameController = TextEditingController(text: widget.name);
    _emailController = TextEditingController(text: widget.email);
    _mobileController = TextEditingController(text: widget.mobile);
    initialeclass();
  }

  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    setState(() {
      ROLEID = sharedPreferences.getString("userRole") ?? '';
      Firstname = sharedPreferences.getString("username") ?? '';
      USERID = sharedPreferences.getString("user_id") ?? '';
    });


    // ROLENAME = sharedPreferences.getString("role_name") ?? '';
  }

  Future<void> _pickImage(ImageSource source) async {
    try {
      // Request permissions based on source
      if (source == ImageSource.camera) {
        var status = await Permission.camera.request();
        if (!status.isGranted) {
          ScaffoldMessenger.of(context).showSnackBar(SnackBar(content: Text('Camera permission denied')));
          return;
        }
      } else if (source == ImageSource.gallery) {
        if (Platform.isAndroid) {
          var status = await Permission.storage.request();
          if (!status.isGranted) {
            ScaffoldMessenger.of(context).showSnackBar(SnackBar(content: Text('Gallery permission denied')));
            return;
          }
        } else if (Platform.isIOS) {
          var status = await Permission.photos.request();
          if (!status.isGranted) {
            ScaffoldMessenger.of(context).showSnackBar(SnackBar(content: Text('Gallery permission denied')));
            return;
          }
        }
      }

      final pickedFile = await _picker.pickImage(source: source, imageQuality: 80);
      if (pickedFile != null) {
        setState(() {
          _profileImageFile = File(pickedFile.path);
        });
      }
    } catch (e) {
      print("Image pick error: $e");
    }
  }

  void _showImagePickerOptions() {
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return AlertDialog(
          shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(15)),
          title: Text("Select Image"),
          content: Row(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: [
              Column(
                mainAxisSize: MainAxisSize.min,
                children: [
                  IconButton(
                    icon: Icon(Icons.photo_library, size: 30),
                    onPressed: () {
                      Navigator.pop(context);
                      _pickImage(ImageSource.gallery);
                    },
                  ),
                  Text("Gallery"),
                ],
              ),
              Column(
                mainAxisSize: MainAxisSize.min,
                children: [
                  IconButton(
                    icon: Icon(Icons.camera_alt, size: 30),
                    onPressed: () {
                      Navigator.pop(context);
                      _pickImage(ImageSource.camera);
                    },
                  ),
                  Text("Camera"),
                ],
              ),
            ],
          ),
        );
      },
    );
  }



  Future<void> _submit() async {
    try {
      String name = _nameController.text.trim();
      String email = _emailController.text.trim();
      String mobile = _mobileController.text.trim();

      if (name.isEmpty || mobile.isEmpty|| email.isEmpty) {
            ScaffoldMessenger.of(context).showSnackBar(
              SnackBar(content: Text("All fields are required")),
            );
            return;
          }

      // TODO: Send to API with _profileImageFile if not null
      print("Name: $name");
      print("Email: $email");
      print("New image: ${_profileImageFile?.path}");
      DialogHelper.showLoading(context);
      final headers = await getAuthHeaders();

      var request = http.MultipartRequest(
            'POST',
            Uri.parse('${apiService.BaseURL}${apiService.PROFILEUPDATE}'),
        // Replace with your server URL
          );
      request.headers.addAll(headers);

      if (_profileImageFile != null) {
            print('Profile image file path: ${_profileImageFile!.path}');
            request.files.add(
              await http.MultipartFile.fromPath(
                'profile', // Replace with your field name on the server
                _profileImageFile!.path,
              ),
            );
          }
      // Debug prints
      //request.fields['old_image'] = _profileImageUrl.toString();


      request.fields['email'] =email;
      request.fields['mobile'] = mobile;
      request.fields['name'] = name;
      request.fields['user_id'] = USERID;
      print('Request URL: ${request.url}');
      print('Fields:');
      request.fields.forEach((key, value) {
            print('$key: $value');
          });


      var streamedResponse = await request.send();
      var response = await http.Response.fromStream(streamedResponse);
      if (response.statusCode == 200) {
        sharedPreferences.setString('username', name);
            DialogHelper.dismissDialog();
        FocusScope.of(context).unfocus(); // This dismisses the keyboard
            Fluttertoast.showToast(
              msg: "Profile uploaded successfully",
              toastLength: Toast.LENGTH_SHORT,
              gravity: ToastGravity.BOTTOM,
              timeInSecForIosWeb: 1,
              backgroundColor: Colors.black,
              textColor: Colors.white,
              fontSize: 16.0,
            );

          //  dismissDailog();


        switch (ROLEID) {
          case "2":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => AdminDashboardScreen()),
            );
            break;
          case "3":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => TranscrpitDashboardScreen()),
            );
            break;
          case "4":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => DoctorDashboardScreen()),
            );
            break;
          case "5":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => HospitalDashboardScreen()),
            );
            break;
          default:
          // Handle unknown ROLEID or do nothing
            break;
        }




      }else if (response.statusCode == 400){
            DialogHelper.dismissDialog();


          }


          else {
            DialogHelper.dismissDialog();
            // Handle error
            ScaffoldMessenger.of(context).showSnackBar(
              SnackBar(content: Text("Upload failed")),
            );
            //dismissDailog();
          }
    } on SocketException {
      DialogHelper.dismissDialog();
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch ');
    } catch (e) {
      print(e);
    }
  }
  Color getBackgroundColor(String roleId) {
    switch (roleId) {
      case "2": // Admin
        return Color(0xffC85D06);

      case "3": // Admin
        return Color(0xffb3b300);
      case "4": // Doctor
        return Color(0xff1F5C93); // Greenish
      case "5": // Hospital
        return Color(0xff004D40); // Purple
      default:
        return Colors.grey; // Default or unknown
    }
  }


  @override
  Widget build(BuildContext context) {


    return  WillPopScope(
      onWillPop: () async {



        switch (ROLEID) {
          case "2":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => AdminDashboardScreen()),
            );
            break;
          case "3":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => TranscrpitDashboardScreen()),
            );
            break;
          case "4":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => DoctorDashboardScreen()),
            );
            break;
          case "5":
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => HospitalDashboardScreen()),
            );
            break;
          default:
          // Handle unknown ROLEID or do nothing
            break;
        }

        return false; // Prevent default pop
      },
      child: Scaffold(

        appBar: AppBar(title: Text('Edit Profile',style: TextStyle(color: Colors.white),

        ),
          backgroundColor: getBackgroundColor(ROLEID),
          iconTheme: IconThemeData(color: Colors.white),),
        body: SingleChildScrollView(
          padding: EdgeInsets.all(16),
          child: Form(
            key: _formKey,
            child: Column(
              children: [
                GestureDetector(
                  onTap: _showImagePickerOptions,
                  child: Stack(
                    alignment: Alignment.center,
                    children: [
                      CircleAvatar(
                        radius: 70,
                        backgroundColor: Colors.grey.shade200,
                        backgroundImage: _profileImageFile != null
                            ? FileImage(_profileImageFile!)
                            : null,
                        child: _profileImageFile == null && (widget.profile_pic == null || widget.profile_pic!.isEmpty)
                            ? Icon(Icons.account_circle_rounded, size: 140, color: Colors.grey)
                            : null,
                      ),
                      if (_profileImageFile == null && widget.profile_pic != null && widget.profile_pic!.isNotEmpty)
                        ClipOval(
                          child: Image.network(
                            widget.profile_pic!,
                            width: 140,
                            height: 140,
                            fit: BoxFit.cover,
                            loadingBuilder: (context, child, loadingProgress) {
                              if (loadingProgress == null) return child;
                              return CircleAvatar(
                                radius: 70,
                                backgroundColor: Colors.grey.shade300,
                                child: Icon(Icons.account_circle_rounded, size: 140, color: Colors.grey),
                              );
                            },
                            errorBuilder: (context, error, stackTrace) => CircleAvatar(
                              radius: 70,
                              backgroundColor: Colors.grey.shade300,
                              child: Icon(Icons.error, size: 140, color: Colors.red),
                            ),
                          ),
                        ),
                      Positioned(
                        bottom: 0,
                        right: 4,
                        child: CircleAvatar(
                          backgroundColor: Colors.white,
                          radius: 18,
                          child: Icon(Icons.edit, color: Colors.black, size: 20),
                        ),
                      ),
                    ],
                  ),
                ),




                SizedBox(height: 20),
                TextFormField(
                  controller: _nameController,
                  decoration: InputDecoration(
                    labelText: "Name",
                    border: OutlineInputBorder(),
                  ),
                  validator: (value) {
                    if (value == null || value.trim().isEmpty) {
                      return 'Name is required';
                    }
                    return null;
                  },
                ),
                SizedBox(height: 12),
                TextFormField(
                  controller: _mobileController,
                  decoration: InputDecoration(labelText: "Mobile", border: OutlineInputBorder()),
                  keyboardType: TextInputType.number,
                  inputFormatters: [
                    FilteringTextInputFormatter.digitsOnly,             // Allow only digits
                    LengthLimitingTextInputFormatter(10),               // Limit to 10 digits
                  ],
                  validator: (value) {
                    if (value == null || value.isEmpty) {
                      return 'Mobile number is required';
                    } else if (!RegExp(r'^[0-9]{10}$').hasMatch(value)) {
                      return 'Enter a valid 10-digit mobile number';
                    }
                    return null;
                  },
                ),
                SizedBox(height: 12),
                TextFormField(
                  controller: _emailController,
                  decoration: InputDecoration(labelText: "Email", border: OutlineInputBorder()),
                  keyboardType: TextInputType.emailAddress,
                  validator: (value) {
                    if (value == null || value.isEmpty) {
                      return 'Email is required';
                    } else if (!RegExp(r'^[\w-\.]+@([\w-]+\.)+[\w]{2,4}$').hasMatch(value)) {
                      return 'Enter a valid email address';
                    }
                    return null;
                  },
                ),
                SizedBox(height: 20),
                ElevatedButton(
                  onPressed:(){
                    if (_formKey.currentState!.validate()) {
                      // Proceed with submission
                      _submit();
                    }
                  },

                  style: ElevatedButton.styleFrom(
                    minimumSize: Size(double.infinity, 50),
                    backgroundColor: getBackgroundColor(ROLEID),
                  ),
                  child: Text("Save Changes",style: TextStyle(color: Colors.white),),
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}