import 'dart:convert';
import 'dart:io';

import 'package:audioplayers/audioplayers.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:http/http.dart' as http;
import 'package:intl/intl.dart';
import 'package:search_choices/search_choices.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../../Networking/ApiService.dart';
import '../../../Networking/DialogHelper.dart';
import '../../../Networking/getAuthHeaders.dart';
import '../../Doctor/dashboard/DoctorFileScreen.dart';

class AdminFileScreen extends StatefulWidget {
  const AdminFileScreen({super.key});

  @override
  State<AdminFileScreen> createState() => _AdminFileScreenState();
}

class _AdminFileScreenState extends State<AdminFileScreen> {
  final ApiService apiService = ApiService();
  late SharedPreferences sharedPreferences;
  String Firstname="",USERID="",ROLEID="",selectdoctor="",selecthospital="",HOSPTALID="",HOSPITLANAME="";

  final AudioPlayer _audioPlayer = AudioPlayer();
  bool _isPlaying = false;
  String _currentPlayingAudio = '';

  List<AudioFile> audioFiles = [];
  Future<List<Map<String, dynamic>>>? _doctorFuture;
  Future<List<Map<String, dynamic>>>? _hospitalFuture;

  String DOCTORID="",DOCTORNAME="";
  DateTime? selectedDate;
  DateTime? selectedMonth;
  String Slecteddate="";
  String Slectedmonth="";
  @override
  void initState() {
    super.initState();
    SystemChrome.setSystemUIOverlayStyle(SystemUiOverlayStyle(
      statusBarColor: Color(0xffFF9C4B), // or any color
      statusBarIconBrightness: Brightness.light,
    ));
    initialeclass();
  }
  initialeclass() async {
    sharedPreferences = await SharedPreferences.getInstance();
    Firstname = sharedPreferences.getString("username") ?? '';
    USERID = sharedPreferences.getString("user_id") ?? '';
    ROLEID = sharedPreferences.getString("userRole") ?? '';
    // ROLENAME = sharedPreferences.getString("role_name") ?? '';
    Filesapi(Slecteddate,Slectedmonth);
    setState(() {
      _hospitalFuture=Apihospitallist();
      _doctorFuture = Apidoctorlist(); // Call your API method
    });
  }

  // Filesapi function
  Future<void> Filesapi(String? selectedDate, String? selectedMonth) async {
    try {
      DialogHelper.showLoading(context);
      final headers = await getAuthHeaders();
      final Uri url = Uri.parse(apiService.BaseURL + apiService.FILELIST).replace(
        queryParameters: {
          'hospital_id': HOSPTALID,
          'doctor_id': DOCTORID,
          'date': selectedDate ?? '',
          'month': selectedMonth ?? '',
        },
      );

      print("GET Request URL: $url");

      final response = await http.get(
        url,
          headers: headers,
      );

      DialogHelper.dismissDialog();

      if (response.statusCode == 200) {
        print(response.body);
        final Map<String, dynamic> jsonResponse = json.decode(response.body);
        final List<dynamic> responseData = jsonResponse['files'] ?? [];

        setState(() {
          audioFiles = responseData.map((fileJson) => AudioFile.fromJson(fileJson)).toList();
        });
      } else {
        setState(() {
          audioFiles = []; // <-- Clear the list so UI updates
        });
        print("Response Status Code: ${response.statusCode}");
        print("Response Body: ${response.body}");
        throw Exception('Failed to load files');
      }
    } on SocketException {
      DialogHelper.dismissDialog();
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
    } catch (e) {
      DialogHelper.dismissDialog();
      print("Error: $e");
    }
  }


  Future<List<Map<String, dynamic>>> Apihospitallist() async {
    try {
      final headers = await getAuthHeaders();
      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.HOSPITALLIST ) ,headers: headers);
      print(apiService.BaseURL + apiService.HOSPITALLIST );

      if (response.statusCode == 200) {
        // Decode the JSON response
        final decoded = json.decode(response.body);

        // Access the list inside the "data" key
        final List<dynamic> data = decoded['hospitals'];

        // Convert and return as List<Map<String, dynamic>>
        return List<Map<String, dynamic>>.from(data);
      } else {
        throw Exception('Failed to load doctor list');
      }
    } on SocketException {
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch');
    } catch (e) {
      print("Error: $e");
      throw Exception('An error occurred: $e');
    }
  }
  Future<List<Map<String, dynamic>>> Apidoctorlist() async {
    try {
      final headers = await getAuthHeaders();
      final response = await http.get(Uri.parse(apiService.BaseURL + apiService.Doctorlist + "/"+HOSPTALID), headers: headers);
      print(apiService.BaseURL + apiService.Doctorlist + "/"+HOSPTALID);

      if (response.statusCode == 200) {
        // Decode the JSON response
        final decoded = json.decode(response.body);

        // Access the list inside the "data" key
        final List<dynamic> data = decoded['data'];

        // Convert and return as List<Map<String, dynamic>>
        return List<Map<String, dynamic>>.from(data);
      } else {
        throw Exception('Failed to load doctor list');
      }
    } on SocketException {
      Fluttertoast.showToast(
        msg: "Network error! Please retry.",
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        backgroundColor: Colors.red,
        textColor: Colors.white,
      );
      throw Exception('Network error: Unable to fetch');
    } catch (e) {
      print("Error: $e");
      throw Exception('An error occurred: $e');
    }
  }



  void _toggleAudio(String fileUrl, String name) async {
    if (_currentPlayingAudio == name) {
      // If the same audio is clicked, pause it
      if (_isPlaying) {
        await _audioPlayer.pause();
        setState(() {
          _isPlaying = false;
        });
      }
    } else {
      // Stop the current audio and start the new one
      await _audioPlayer.stop();
      await _audioPlayer.play(UrlSource(fileUrl)); // ✅ Fix is here
      setState(() {
        _isPlaying = true;
        _currentPlayingAudio = name;
      });
    }
  }


  @override
  void dispose() {
    _audioPlayer.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Stack(
        children: [
          Container(
            height: 150,
            decoration: BoxDecoration(
              color: Color(0xffFF9C4B), // Example background color
              borderRadius: BorderRadius.only(
                bottomLeft: Radius.circular(20.0),
                bottomRight: Radius.circular(20.0),
              ),
            ), // Example background color
          ),
          Padding(
            padding: const EdgeInsets.only(top: 110.0,left: 10.0,right:10.0),
            child: Column(
              children: [
                Row(
                  children: [
                    Expanded(
                      child: Container(
                        child: Container(
                          height: 50,

                          padding: EdgeInsets.zero,
                          decoration: BoxDecoration(
                              border: Border.all(color: Colors.black),
                              borderRadius: BorderRadius.circular(8),
                              color: Colors.white

                          ),
                          child:
                          FutureBuilder<List<Map<String, dynamic>>>(
                            future: _hospitalFuture,
                            builder: (context, snapshot) {
                              if (snapshot.connectionState == ConnectionState.waiting) {
                                return SizedBox(
                                    height: 40,
                                    child: Center(child: CircularProgressIndicator())
                                );
                              } else if (snapshot.hasError || !snapshot.hasData) {
                                return SizedBox(
                                  height: 40,
                                  child: Center(
                                    child: Text('No Hospital Found', style: TextStyle(color: Colors.black)),
                                  ),
                                );
                              } else {
                                return Padding(
                                  padding: const EdgeInsets.symmetric(horizontal: 8.0),
                                  child: SearchChoices.single(
                                    padding: EdgeInsets.zero,
                                    items: snapshot.data!
                                        .map<DropdownMenuItem<String>>((item) {
                                      return DropdownMenuItem<String>(
                                        value: '${item['hospital_name']},${item['userId']}',
                                        child: Text(
                                          item['hospital_name'],
                                          style: TextStyle(fontSize: 14),
                                        ),
                                      );
                                    }).toList(),
                                    value: selecthospital,
                                    hint: Text(
                                      "Select Hospital",
                                      style: TextStyle(color: Colors.black, fontSize: 16,fontWeight: FontWeight.bold),
                                    ),
                                    searchHint: "Select Hospital",
                                    underline: Container(),
                                    // removes dropdown icon
                                    onChanged: (newValue) {
                                      setState(() {
                                        selecthospital = newValue as String;
                                        List<String> parts = newValue.split(',');
                                        HOSPTALID = parts[1];
                                        HOSPITLANAME = parts[0];
                                        selectdoctor = "";
                                        DOCTORID="";
                                        DOCTORNAME="";
                                        _doctorFuture = Apidoctorlist();

                                        Filesapi(Slecteddate,Slectedmonth);


                                      });
                                    },
                                    closeButton: "close",
                                    isExpanded: true,
                                    displayClearIcon: false,
                                    style: TextStyle(color: Colors.black), // ✅ Selected item text color
                                    dialogBox: true, // 🟢 This avoids expanding in place
                                  ),
                                );
                              }
                            },
                          ),
                        ),
                      ),
                    ),
                    Expanded(
                      child: Container(
                        child: Container(
                          height: 50,

                          padding: EdgeInsets.zero,
                          decoration: BoxDecoration(
                              border: Border.all(color: Colors.black),
                              borderRadius: BorderRadius.circular(8),
                              color: Colors.white

                          ),
                          child:
                          FutureBuilder<List<Map<String, dynamic>>>(
                            future: _doctorFuture,
                            builder: (context, snapshot) {
                              if (snapshot.connectionState == ConnectionState.waiting) {
                                return SizedBox(
                                    height: 40,
                                    child: Center(child: CircularProgressIndicator())
                                );
                              } else if (snapshot.hasError || !snapshot.hasData) {
                                return SizedBox(
                                  height: 40,
                                  child: Center(
                                    child: Text('No Doctor Found', style: TextStyle(color: Colors.black)),
                                  ),
                                );
                              } else {
                                return Padding(
                                  padding: const EdgeInsets.symmetric(horizontal: 8.0),
                                  child: SearchChoices.single(
                                    padding: EdgeInsets.zero,
                                    items: snapshot.data!
                                        .map<DropdownMenuItem<String>>((item) {
                                      return DropdownMenuItem<String>(
                                        value: '${item['name']},${item['id']}',
                                        child: Text(
                                          item['name'],
                                          style: TextStyle(fontSize: 14),
                                        ),
                                      );
                                    }).toList(),
                                    value: selectdoctor,
                                    hint: Text(
                                      "Select Doctor",
                                      style: TextStyle(color: Colors.black, fontSize: 16,fontWeight: FontWeight.bold),
                                    ),
                                    searchHint: "Select Doctor",
                                    underline: Container(),
                                    // removes dropdown icon
                                    onChanged: (newValue) {
                                      setState(() {
                                        selectdoctor = newValue as String;
                                        List<String> parts = newValue.split(',');
                                        DOCTORID = parts[1];
                                        DOCTORNAME = parts[0];

                                        Filesapi(Slecteddate,Slectedmonth);


                                      });
                                    },
                                    closeButton: "close",
                                    isExpanded: true,
                                    displayClearIcon: false,
                                    style: TextStyle(color: Colors.black), // ✅ Selected item text color
                                    dialogBox: true, // 🟢 This avoids expanding in place
                                  ),
                                );
                              }
                            },
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
                SizedBox(height: 10),
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    // Month Picker Button
                    ElevatedButton.icon(
                      onPressed: () async {
                        final now = DateTime.now();
                        final picked = await showDatePicker(
                          context: context,
                          initialDate: selectedMonth ?? DateTime(now.year, now.month),
                          firstDate: DateTime(2000),
                          lastDate: DateTime(now.year, now.month, 1),
                          helpText: "Select Month",
                          initialEntryMode: DatePickerEntryMode.calendar,
                        );

                        if (picked != null) {
                          final isSameMonth = selectedDate != null &&
                              selectedDate!.year == picked.year &&
                              selectedDate!.month == picked.month;

                          setState(() {
                            selectedMonth = DateTime(picked.year, picked.month);
                            Slectedmonth = DateFormat('yyyy-MM').format(picked);

                            if (!isSameMonth) {
                              selectedDate = null;
                              Slecteddate = "";
                            }

                            Filesapi(Slecteddate ?? "", Slectedmonth ?? "");
                          });

                          print("Selected Month: ${DateFormat('yyyy-MM').format(picked)}");
                        }
                      },
                      icon: Icon(Icons.calendar_month),
                      label: Text(
                        selectedMonth != null
                            ? DateFormat('yyyy-MM').format(selectedMonth!)
                            : 'Select Month',
                      ),
                      style: ElevatedButton.styleFrom(
                        elevation: 0,
                        backgroundColor: Colors.transparent,
                        foregroundColor: Colors.black,
                        side: BorderSide(color: Colors.black),
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.circular(8),
                        ),
                      ),
                    ),

                    SizedBox(width: 10),

                    // Date Picker Button
                    ElevatedButton.icon(
                      onPressed: () async {
                        final DateTime? picked = await showDatePicker(
                          context: context,
                          initialDate: selectedDate ?? DateTime.now(),
                          firstDate: DateTime(2000),
                          lastDate: DateTime.now(),
                        );

                        if (picked != null) {
                          final isSameMonth = selectedMonth != null &&
                              selectedMonth!.year == picked.year &&
                              selectedMonth!.month == picked.month;

                          setState(() {
                            selectedDate = picked;
                            Slecteddate = DateFormat('dd-MM-yyyy').format(picked);

                            if (!isSameMonth) {
                              selectedMonth = null;
                              Slectedmonth = "";
                            }

                            Filesapi(Slecteddate ?? "", Slectedmonth ?? "");
                          });

                          print("Selected Date: ${DateFormat('dd-MM-yyyy').format(picked)}");
                        }
                      },
                      icon: Icon(Icons.date_range),
                      label: Text(
                        selectedDate != null
                            ? DateFormat('dd-MM-yyyy').format(selectedDate!)
                            : 'Select Date',
                      ),
                      style: ElevatedButton.styleFrom(
                        elevation: 0,
                        backgroundColor: Colors.transparent,
                        foregroundColor: Colors.black,
                        side: BorderSide(color: Colors.black),
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.circular(8),
                        ),
                      ),
                    ),
                  ],
                ),
                // File Count and List
                Expanded(
                  child: Padding(
                    padding: const EdgeInsets.symmetric(horizontal: 5.0),
                    child: audioFiles.isEmpty
                        ? Center(
                      child: Text(
                        "No Files Found",
                        style: TextStyle(
                          color: Colors.black,
                          fontSize: 20,
                          fontWeight: FontWeight.bold,
                        ),
                      ),
                    )
                        : Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          'Total Files: ${audioFiles.length}',
                          style: TextStyle(
                            fontSize: 16,
                            fontWeight: FontWeight.bold,
                            color: Colors.black,
                          ),
                        ),
                        Expanded(
                          child: ListView.builder(
                            itemCount: audioFiles.length,
                            itemBuilder: (context, index) {
                              final audio = audioFiles[index];
                              return Card(
                                elevation: 4,
                                margin: EdgeInsets.all(4),
                                child: Padding(
                                  padding: const EdgeInsets.all(6.0),
                                  child: IntrinsicHeight(
                                    child: Row(
                                      mainAxisSize: MainAxisSize.min,
                                      children: [
                                        SvgPicture.asset(
                                          'assets/wave.svg',
                                          height: 40,
                                          fit: BoxFit.contain,
                                        ),
                                        const SizedBox(width: 6),
                                        Expanded(
                                          child: Text(
                                            audio.fileName ?? '',
                                            style: TextStyle(
                                              fontWeight: FontWeight.bold,
                                              fontSize: 16,
                                            ),
                                          ),
                                        ),
                                        VerticalDivider(
                                          color: Colors.grey,
                                          thickness: 0.5,
                                          width: 10,
                                        ),
                                        IconButton(
                                          icon: Icon(
                                            _currentPlayingAudio == audio.fileName && _isPlaying
                                                ? Icons.pause_circle_outline_outlined
                                                : Icons.play_circle_outline_outlined,
                                            color: Color(0xff1F5C93),
                                            size: 40,
                                          ),
                                          onPressed: () {
                                            _toggleAudio(audio.audioPath.toString(), audio.fileName.toString());
                                          },
                                        ),
                                        VerticalDivider(
                                          color: Colors.grey,
                                          thickness: 0.5,
                                          width: 10,
                                        ),
                                        IconButton(
                                          icon: SvgPicture.asset(
                                            audio.transcription == null || audio.transcription.toString().isEmpty
                                                ? 'assets/filered.svg'
                                                : 'assets/fileblue.svg',
                                            height: 30,
                                            width: 30,
                                          ),
                                          onPressed: () {
                                            if (audio.transcription == null || audio.transcription.toString().isEmpty) {
                                              Fluttertoast.showToast(
                                                msg: "No Transcription Found",
                                                toastLength: Toast.LENGTH_SHORT,
                                                gravity: ToastGravity.BOTTOM,
                                                backgroundColor: Colors.red,
                                                textColor: Colors.white,
                                              );
                                            } else {
                                              _showDescriptionDialog(audio.transcription);
                                            }
                                          },
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              );
                            },
                          ),
                        ),
                      ],
                    ),
                  ),
                ),

              ],
            ),
          ),
        ],
      ),
    );
  }
  void _showDescriptionDialog(String? description) {
    showModalBottomSheet(
      context: context,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.vertical(top: Radius.circular(20)),
      ),
      isScrollControlled: true,
      builder: (BuildContext context) {
        return Stack(
          children: [
            Padding(
              padding: const EdgeInsets.fromLTRB(16, 40, 16, 32), // Top padding to avoid close button
              child: Column(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  const Text(
                    'Description',
                    style: TextStyle(fontSize: 18, fontWeight: FontWeight.bold),
                  ),
                  const Divider(),
                  const SizedBox(height: 8),
                  Text(
                    (description == null || description.trim().isEmpty)
                        ? "No description found"
                        : description,
                    style: const TextStyle(fontSize: 16),
                  ),
                  const SizedBox(height: 16),
                ],
              ),
            ),
            Positioned(
              top: 8,
              right: 8,
              child: IconButton(
                icon: const Icon(Icons.close),
                onPressed: () => Navigator.of(context).pop(),
              ),
            ),
          ],
        );
      },
    );
  }

}

class AudioFile {
  AudioFile({
    required this.fileName,
    required this.userId,
    required this.audioPath,
    required this.transcription,
    required this.fileDetails,
  });

  final String? fileName;
  final int? userId;
  final String? audioPath;
  final String? transcription;
  final String? fileDetails;

  factory AudioFile.fromJson(Map<String, dynamic> json){
    return AudioFile(
      fileName: json["file_name"],
      userId: json["user_id"],
      audioPath: json["audio_path"],
      transcription: json["transcription"],
      fileDetails: json["file_details"],
    );
  }

}
