<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;

use App\Models\OrientationModel;
use Illuminate\Http\Request;

class OrientationController extends Controller
{
     public function index()
    {
       
        $records   =  OrientationModel::orderBy('orientation_name', 'ASC')->get();
        return view('backend.orientation.list', compact('records'));
    }

    public function orientationDetails($id = '')
    {
      
        $record = '';
        if ($id > 0) {
            $record = OrientationModel::WHere('id', $id)->first();
        }
        return view('backend.orientation.add_edit', compact('record'));
    }

    public function storeUpdateOrientation(Request $request)
    {
        $input     = $request->all();
        $id        = isset($input['id']) ? $input['id'] : 0;

        $dataArr = [];
        foreach ($input as $key => $val) {
            if ($key != '_token' && $key != 'id' )
                $dataArr[$key] = $val;
        }

       
        if ($id == 0 || $id == '') {
            $request->validate([
                'orientation_name'          =>  "required|unique:orientation,orientation_name",
              
            ]);
           $insert = OrientationModel::create($dataArr);
           if($insert['id'] > 0)
           {
               return redirect()->route('orientation')->with('success', 'Body Type Saved Successfully');
           }else{
               return redirect()->route('orientation')->with('error', 'Something went wrong!');
           }
           
        } else {
            $request->validate([
                'orientation_name'          =>  "required",               
            ]);
            $update = OrientationModel::Where('id',$id)->update($dataArr);
            return redirect()->route('orientation')->with('success', 'Body Type Updated Successfully');;
        }        
    }
}
