 @extends('backend.app_template')
 @section('title','Reported Ads')
 @section('content')
 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">
             <h6 class="mb-0 flex-grow-1">Reported Ads</h6>
             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Pages</a></li>
                         <li class="breadcrumb-item active" aria-current="page">Reported Ads</li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="card">
                 <div class="card-body">
                     <form method="POST" action="<?= route('reported-ads') ?>">
                        @csrf
                         <div class="row">
                             <div class="col-md-4">
                                 <label>Select Date Range</label>
                                 <input type="text" id="range-picker"  class="form-control" value="<?= isset($from) ? $from:'' ?>" name="from" />
                             </div>
                             <div class="col-md-4">
                                 <label>Service Type</label>
                                 <select  class="form-control select2" id="service" name="service" >
                                     <option value="">--select--</option>
                                     <?php
                                        if (isset($serviceData)) {
                                            foreach ($serviceData as $val) { ?>
                                             <option <?php echo (isset($service) && $service == $val->id) ? 'selected' : '' ?> value="<?php echo $val->id ?>"><?php echo ucwords($val->service_type) ?></option>
                                     <?php }
                                        }
                                        ?>
                                 </select>
                             </div>
                             
                         </div>
                         <div class="d-flex mt-2">
                                <input type="submit" name="submit" value="Search" class="btn btn-primary" />
                         </div>
                         

                     </form>
                 </div>
             </div>

             <table id="datatables" class="table table-responsive   table-bordered w-100 mt-5">
                 <thead>
                     <tr>
                         <th>S.No</th>
                         <th>Email ID</th>
                         <th>Date Reported</th>  
                         <th>Issues</th>
                         <th>Images</th>
                         <th>View Advertisement</th>
                         <th>Action</th>                     
                     </tr>
                 </thead>
                 <tbody>
                     <?php if (isset($records)) {
                            $i = 1;
                            foreach ($records as $key => $row) { ?>
                             <tr>
                                 <td><?php echo $i ?></td>
                                 <td><?php echo $row->email ?></td>
                                 <td><?php echo date('d M Y',strtotime($row->created_at)) ?></td>                                 
                                 <td>
                                    <a onclick="showIssues('<?= htmlspecialchars($row->message, ENT_QUOTES) ?>')" href="javascript:void(0)"  class="badge bg-pill bg-primary"><i class="bi bi-eye"></i> View </a>
                                 </td>

                                  <td>
                                    <a  href="javascript:void(0)"  class="badge bg-pill bg-primary"><i class="bi bi-eye"></i> View </a>
                                 </td>
                                 
                                 <td>
                                    <a onclick="showDetails('<?= $row->service_id ?>')" href="javascript:void(0)"  class="badge bg-pill bg-primary"><i class="bi bi-eye"></i> View </a>
                                 </td>
                                <td>
                                    <a data-bs-toggle="tooltip" data-bs-title="<?= ($row->status == 2) ? 'Un Block':'Block' ?>" title="<?= ($row->status == 2) ? 'Un Block':'Block' ?>" data-original-title="<?= ($row->status == 2) ? 'UnBlock':'Block' ?>" href="javascript:void(0)" onclick="changeStatus('<?php echo $row->id ?>','<?= ($row->status == 2) ? 1:2 ?>','Advertisement')" class="btn btn-sm btn-primary"><i class="<?= ($row->status == 2) ? 'bi bi-unlock-fill':'bi bi-ban-fill' ?> "></i></a>                                   
                                    <a data-bs-toggle="tooltip" data-bs-title="Delete" title="Delete" data-original-title="Delete" href="javascript:void(0)" onclick="commonDelete('<?php echo $row->id ?>','Advertisement')" class="btn btn-sm btn-danger"><i class="bi bi-trash-fill"></i></a>                                    
                                </td>           
                             </tr>
                     <?php $i++;
                            }
                        } ?>

                 </tbody>
             </table>
         </div>
     </div>
 </main>
 <div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalLabel">
                   Verification Video
                </h5>
                <button type="button" class="btn-close icon-btn-sm" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ri-close-large-line fw-semibold"></i>
                </button>
            </div>
            <div class="modal-body">
                 <video id="modalVideo" width="100%" height="430" controls>
                    <source id="videoSource" src="" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
            </div>           
        </div>
    </div>
</div>
<script>
    function showImages(url)
    {
        const videoSrc = $("#videoSource");
        const video = $("#modalVideo")[0];
        $('#videoModal').modal('show');
        videoSrc.attr("src", url);   
        video.load();
        video.play();
    }
 </script>
 @endsection