<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\ServiceRequestController;
use App\Http\Controllers\SupportController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/session/check', function () {
    return response()->json([
        'alive' => session()->has('_token')
    ]);
})->name('session.check');

Route::get('/', [FrontendController::class, 'index'])->name('/');
Route::get('contact', [FrontendController::class, 'contact'])->name('contact');
Route::get('privacy-policy', [FrontendController::class, 'privacy_policy'])->name('privacy-policy');
Route::get('terms-conditions', [FrontendController::class, 'terms_condition'])->name('terms-conditions');
Route::get('about-us', [FrontendController::class, 'about'])->name('about-us');
Route::get('career', [FrontendController::class, 'career'])->name('career');
Route::get('product', [FrontendController::class, 'products'])->name('product');
Route::get('sendSms', [FrontendController::class, 'sendSms'])->name('sendSms');
Route::get('products/{name?}', [FrontendController::class, 'getProduct'])->name('products');
Route::get('download/{token?}', [FrontendController::class, 'download'])->name('download');
Route::match(['get','post'],'getProducts', [FrontendController::class, 'getAjaxProducts'])->name('getProducts');
Route::post('submit-enquiry', [FrontendController::class, 'submitEnquiry'])->name('submit-enquiry');
Route::post('download-catalog', [FrontendController::class, 'downloadCatalog'])->name('download-catalog');
Route::post('send-career', [FrontendController::class, 'sendCareer'])->name('send-career');
Route::post('contact-form', [FrontendController::class, 'sendMail'])->name('contact-form');

