<?php

use App\Http\Controllers\Backend\AuthController;
use App\Http\Controllers\Backend\BodyTypeController;
use App\Http\Controllers\Backend\BrandController;
use App\Http\Controllers\Backend\CommonController;
use App\Http\Controllers\Backend\CountryController;
use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\Backend\EyeController;
use App\Http\Controllers\Backend\HairController;
use App\Http\Controllers\Backend\IndustryController;
use App\Http\Controllers\Backend\LanguageController;
use App\Http\Controllers\Backend\MetaController;
use App\Http\Controllers\Backend\OrientationController;
use App\Http\Controllers\Backend\PageController;
use App\Http\Controllers\Backend\ReportsController;
use App\Http\Controllers\Backend\UserController;
use App\Http\Controllers\Backend\SettingsController;
use App\Http\Controllers\Backend\SliderController;
use App\Http\Controllers\Backend\TypeController;
use App\Http\Controllers\Backend\UserGuideController;

use Illuminate\Support\Facades\Route;

Route::get("/", [AuthController::class, 'index'])->name('login');
Route::post("authLogin", [AuthController::class, 'authLogin'])->name('authLogin');

Route::middleware('auth.request')->group(function () {
    Route::get("dashboard", [DashboardController::class, 'dashboard'])->name('dashboard');
    Route::get("logout", [AuthController::class, 'logout'])->name('logout');
    Route::get("blank", [DashboardController::class, 'blank'])->name('blank');
    Route::get("users", [UserController::class, 'users'])->name('users');

    Route::get('country', [CountryController::class, 'country'])->name('country');
    Route::get('addCountry/{id?}', [CountryController::class, 'addCountry'])->name('addCountry');
    Route::post('storeUpdateCountry', [CountryController::class, 'storeUpdateCountry'])->name('storeUpdateCountry');

    Route::get('slider', [SliderController::class, 'slider'])->name('slider');
    Route::get('addSlider/{id?}', [SliderController::class, 'addSlider'])->name('addSlider');
    Route::post('storeUpdateSlider', [SliderController::class, 'storeUpdateSlider'])->name('storeUpdateSlider');

    Route::get('brand', [BrandController::class, 'brand'])->name('brand');
    Route::get('addBrand/{id?}', [BrandController::class, 'addBrand'])->name('addBrand');
    Route::post('storeUpdateBrand', [BrandController::class, 'storeUpdateBrand'])->name('storeUpdateBrand');


    Route::get('type', [TypeController::class, 'type'])->name('type');
    Route::get('addType/{id?}', [TypeController::class, 'addType'])->name('addType');
    Route::post('storeUpdateType', [TypeController::class, 'storeUpdateType'])->name('storeUpdateType');


    Route::get('industry', [IndustryController::class, 'industry'])->name('industry');
    Route::get('addIndustry/{id?}', [IndustryController::class, 'addIndustry'])->name('addIndustry');
    Route::post('storeUpdateIndustry', [IndustryController::class, 'storeUpdateIndustry'])->name('storeUpdateIndustry');


    Route::get('language', [LanguageController::class, 'language'])->name('language');
    Route::get('addLanguage/{id?}', [LanguageController::class, 'addLanguage'])->name('addLanguage');
    Route::post('storeUpdateLanguage', [LanguageController::class, 'storeUpdateLanguage'])->name('storeUpdateLanguage');


    Route::get('meta', [MetaController::class, 'meta'])->name('meta');
    Route::get('addMeta/{id?}', [MetaController::class, 'addMeta'])->name('addMeta');
    Route::post('storeUpdateMeta', [MetaController::class, 'storeUpdateMeta'])->name('storeUpdateMeta');

    Route::get('pages', [PageController::class, 'pages'])->name('pages');
    Route::get('addPage/{id?}', [PageController::class, 'addPage'])->name('addPage');
    Route::post('storeUpdatePage', [PageController::class, 'storeUpdatePage'])->name('storeUpdatePage');

    Route::get('hair', [HairController::class, 'hair'])->name('hair');
    Route::get('addHair/{id?}', [HairController::class, 'addHair'])->name('addHair');
    Route::post('storeUpdateHair', [HairController::class, 'storeUpdateHair'])->name('storeUpdateHair');

    Route::get('eye', [EyeController::class, 'eye'])->name('eye');
    Route::get('addEye/{id?}', [EyeController::class, 'addEye'])->name('addEye');
    Route::post('storeUpdateEye', [EyeController::class, 'storeUpdateEye'])->name('storeUpdateEye');
    //body type dhanaraj

    Route::get('bodyType', [BodyTypeController::class, 'index'])->name('bodyType');
    Route::get('BodyTypeDetails/{id?}', [BodyTypeController::class, 'BodyTypeDetails'])->name('BodyTypeDetails');
    Route::post('storeUpdateBodyType', [BodyTypeController::class, 'storeUpdateBodyType'])->name('storeUpdateBodyType');


    //settings
    Route::get('settings/{id?}', [SettingsController::class, 'settings'])->name('settings');
    Route::post('storeSettings', [SettingsController::class, 'storeSettings'])->name('storeSettings');

    //user video

    Route::get('userVideo', [UserGuideController::class, 'userVideo'])->name('userVideo');
    Route::get('userVideoDetails/{id?}', [UserGuideController::class, 'userVideoDetails'])->name('userVideoDetails');
    Route::post('storeUpdateUserVideo', [UserGuideController::class, 'storeUpdateUserVideo'])->name('storeUpdateUserVideo');
    Route::get('info', [UserGuideController::class, 'info'])->name('info');


    Route::get('orientation', [OrientationController::class, 'index'])->name('orientation');
    Route::get('orientationDetails/{id?}', [OrientationController::class, 'orientationDetails'])->name('orientationDetails');
    Route::post('storeUpdateOrientation', [OrientationController::class, 'storeUpdateOrientation'])->name('storeUpdateOrientation');


    Route::get('profile', [CommonController::class, 'profile'])->name('profile');

    Route::post('/save-profile', [CommonController::class, "saveProfile"])->name('save-profile');
    Route::post('/change-password', [CommonController::class, "changePassword"])->name('change-password');


    Route::post('/updateCommonStatus', [CommonController::class, "updateCommonStatus"])->name('updateCommonStatus');
    Route::post('/commonDelete', [CommonController::class, "commonDelete"])->name('commonDelete');

    Route::match(['get', 'post'], '/web-request', [ReportsController::class, "web_request"])->name('web-request');
    Route::match(['get', 'post'], '/customers', [ReportsController::class, "customers"])->name('customers');
    Route::match(['get', 'post'], '/ads-management', [ReportsController::class, "adsManagement"])->name('ads-management');
    Route::match(['get', 'post'], '/ads-verification', [ReportsController::class, "adsVerification"])->name('ads-verification');
    Route::match(['get', 'post'], '/reported-ads', [ReportsController::class, "reportedAds"])->name('reported-ads');
    Route::match(['get', 'post'], '/general-support', [ReportsController::class, "generalSupport"])->name('general-support');
    Route::match(['get', 'post'], '/get-support', [ReportsController::class, "getSupport"])->name('get-support');
    Route::match(['get', 'post'], '/updateSupportStatus', [ReportsController::class, "updateSupportStatus"])->name('updateSupportStatus');
    Route::match(['get', 'post'], '/vendors', [ReportsController::class, "vendors"])->name('vendors');

    Route::get('showDetails/{id}', [ReportsController::class, 'showDetails'])->name('showDetails');
    Route::match(['get', 'post'], 'vendorDetails/{id}', [ReportsController::class, 'vendorDetails'])->name('vendorDetails');
});
