





@include('base.header')

<style>
    .loader-box {
        width: 100%;
        text-align: center;
        padding: 120px 0;
    }

    .loader-box img {
        width: 120px;
    }

    .main-content {
        display: none;
        padding: 40px 0;
    }

    .container {
        display: flex;
        gap: 40px;
        justify-content: center;
        align-items: flex-start;
        padding: 30px;
    }

    .success-box {
        background: #f0fff4;
        border: 2px solid #38a169;
        padding: 30px;
        border-radius: 12px;
        width: 370px;
        text-align: center;
    }

    .success-icon {
        font-size: 55px;
        color: #38a169;
        font-weight: bold;
    }

    .details-box {
        background: #ffffff;
        padding: 30px;
        border-radius: 12px;
        width: 380px;
        border: 1px solid #e5e7eb;
    }

    .back-btn {
        background: #ccc;
        padding: 6px 14px;
        border-radius: 8px;
        border: none;
        margin-bottom: 15px;
    }

    .warning-box {
        margin-top: 20px;
        padding: 12px;
        font-size: 13px;
        background: #fff3cd;
        border-left: 5px solid #ff9800;
    }
</style>

<body>

    {{-- ================= LOADER WITH TIMER ================= --}}
    <div class="loader-box" id="loaderBox">
        <img src="https://i.gifer.com/ZZ5H.gif" alt="Loading...">
        <h3 style="margin-top:20px;">
            Please wait <span id="timer">60</span> seconds...
        </h3>
    </div>

    {{-- ================= MAIN CONTENT ================= --}}
    <div class="main-content" id="mainContent">

        <div class="container">

            {{-- LEFT BOX --}}
            <div class="success-box">
                <div class="success-icon">✔</div>
                <h3>Thank You!</h3>
                <p>Your request has been submitted successfully.</p>
            </div>

            {{-- RIGHT BOX --}}
            <div class="details-box">

                <button class="back-btn" onclick="window.history.back();">Back</button>

                <h2>Request Summary</h2>

                <span class="label">Spoken Languages:</span>
                <p>{{ $languages_csv ?? 'N/A' }}</p>

                <div class="warning-box">
                    NEVER pay in advance to anyone via Gift / Bing card, Transcash,
                    Neosurf / PCS coupons, Google Play card, etc.
                    They are scammers.
                </div>
            </div>

        </div>
    </div>

    <script>
        // ================= countdown timer =================
        let timeLeft = 60; // 1 minute

        let countdown = setInterval(() => {
            timeLeft--;
            document.getElementById("timer").innerText = timeLeft;

            if (timeLeft <= 0) {
                clearInterval(countdown);

                // hide loader, show content
                document.getElementById('loaderBox').style.display = 'none';
                document.getElementById('mainContent').style.display = 'block';
            }

        }, 1000);
    </script>

</body>

@include('base.footer')

</html>

@include('base.header')

<style>
    body {
        background: #f5f6f8;
        font-family: 'Inter', sans-serif;
    }

    .loader-box {
        width: 100%;
        text-align: center;
        padding: 150px 0;
    }

    .loader-box img {
        width: 120px;
    }

    .main-content {
        display: none;
        padding-top: 20px;
    }

    /* Card grid */
    .vendor-card {
        background: white;
        border-radius: 18px;
        padding: 20px;
        text-align: center;
        box-shadow: 0 4px 14px rgba(0, 0, 0, 0.1);
        margin-bottom: 25px;
        position: relative;
    }

    /* Service badge & online badge row */
    .badge-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .service-badge {
        width: 70px;
        height: 70px;
        background: linear-gradient(135deg, #7918f2, #ac32e4);
        color: white;
        border-radius: 50%;
        font-size: 11px;
        font-weight: 600;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        padding: 8px;
        line-height: 1.1;
    }


    .online-badge {
        background: #00c853;
        color: white;
        font-size: 12px;
        padding: 6px 14px;
        border-radius: 20px;
        font-weight: 600;
    }

    .hot-icon {
        width: 65px;
        height: 65px;
        background: #ff1744;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 15px auto 0;
    }

    .hot-img {
        width: 34px;
    }

    .user-name {
        margin-top: 12px;
        font-size: 17px;
        font-weight: 600;
        color: #222;
    }

    .languages {
        color: #777;
        margin-top: 5px;
        font-size: 13px;
    }
</style>


{{-- LOADER --}}
<div class="loader-box" id="loaderBox">
    <img src="https://i.gifer.com/ZZ5H.gif" alt="Loading...">
    <h3 style="margin-top:20px;">
        Please wait <span id="timer">60</span> seconds...
    </h3>
</div>

<div class="main-content" id="mainContent">

    <a href="/" class="back-link">← Back to Home</a>

    <div class="container">
        <div class="row">

            {{-- LOOP 10 CARDS --}}
            @for ($i = 1; $i <= 10; $i++)
                <div class="col-lg-4 col-md-4 col-sm-6">

                    <div class="vendor-card">

                        <div class="badge-row">
                            <div class="service-badge">Audio/Video Calls</div>
                            <div class="online-badge">● Online</div>
                        </div>

                        <div class="tick-icon">
                            <img src="https://img.icons8.com/emoji/96/fire.png" class="hot-img" alt="Hot">
                        </div>

                        <div class="user-name">Test User {{ $i }}</div>
                        <div class="languages">Tamil, English</div>

                    </div>

                </div>
            @endfor

        </div>
    </div>

</div>



<script>
    let timeLeft = 60;

    let countdown = setInterval(() => {
        timeLeft--;
        document.getElementById("timer").innerText = timeLeft;

        if (timeLeft <= 0) {
            clearInterval(countdown);
            document.getElementById('loaderBox').style.display = 'none';
            document.getElementById('mainContent').style.display = 'block';
        }

    }, 1000);
</script>

@include('base.footer')

</html>