@extends('app_layout')
@section('title','Home')
@section('content')
<main class="main">
    <!-- Hero Section -->
    <section id="hero" style="padding:3px">

        <div class="swiper hero-slider">
            <div class="swiper-wrapper">
                <?php if (isset($slidersData)) {
                    foreach ($slidersData as $row) { ?>
                        <div class="swiper-slide">
                            <div class="hero-slide-bg" style="background-image:url('<?php echo $row->slider_img ?>');">
                                <div class="hero-overlay"></div>
                                <div class="hero-content">
                                    <h1><?php echo $row->slider_caption ?></h1>
                                    <h4><?php echo $row->slider_type ?></h4>
                                    <a href="#">View All</a>
                                </div>
                            </div>
                        </div>
                <?php }
                } ?>
            </div>
            <!-- Pagination -->
            <div class="swiper-pagination"></div>
            <!-- Navigation -->
            <div class="swiper-button-prev"></div>
            <div class="swiper-button-next"></div>
        </div>




    </section>

    <section class="container">
        <div class="row gy-4 visual-display-section">

            <!-- LEFT CONTENT -->
            <div class="col-lg-5 left-content">
                <div class="visual-content">
                    <span class="featured-text">FEATURED</span>
                    <h2>Visual Display</h2>
                    <p>
                        Our advanced visual display solutions are changing the landscape
                        of how we see and interact with the world around us.
                    </p>
                    <a href="#" class="btn view-all-btn">View All</a>
                </div>
            </div>

            <!-- RIGHT GRID -->
            <div class="col-lg-7">
                <div class="row g-4">

                    <div class="col-md-6">
                        <div class="display-card large">
                            <img src="<?php echo asset('assets') ?>/img/signage-tv.png" class="img-fluid" alt="">
                            <div class="display-title">Signage Display</div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="display-card large">
                            <img src="<?php echo asset('assets') ?>/img/portable-projectors.png" class="img-fluid" alt="">
                            <div class="display-title">Projectors</div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="display-card small">
                            <img src="<?php echo asset('assets') ?>/img/led-wall.png" class="img-fluid" alt="">
                            <div class="display-title">LED Wall</div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="display-card small">
                            <img src="<?php echo asset('assets') ?>/img/interactive-display.png" class="img-fluid" alt="">
                            <div class="display-title">Interactive Displays</div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="display-card small">
                            <img src="<?php echo asset('assets') ?>/img/digital-writing-pad.png" class="img-fluid" alt="">
                            <div class="display-title">Digital Writing Pad</div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>


    <section class="container">
        <div class="achievements-banner" data-aos="zoom-in" data-aos-delay="700">
            <div class="row text-center">
                <div class="col-lg-3 col-sm-6">
                    <div class="achievement-item">
                        <i class="bi bi-award"></i>
                        <p>NUMBER OF <br>BRANDS </p>
                        <h3>20+</h3>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="achievement-item">
                        <i class="bi bi-shield-check"></i>
                        <p>NUMBER OF <br>DEALERS</p>
                        <h3>350+</h3>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="achievement-item">
                        <i class="bi bi-clock-history"></i>
                        <p>EXPERIENCE</p>
                        <h3>15+</h3>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="achievement-item">
                        <i class="bi bi-people"></i>
                        <p>SUCCESSFULL PROJECTS<br></p>
                        <h3>2000+</h3>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="row g-4">

            <!-- Monitors -->
            <div class="col-lg-6" data-aos="zoom-in" data-aos-delay="100">
                <div class="category-card bg-sand">
                    <div class="row align-items-center h-100">
                        <div class="col-md-7">
                            <h3>Monitors</h3>
                            <p>Perfect monitor for all Applications</p>
                            <a href="#" class="btn btn-outline-dark">See All</a>
                        </div>
                        <div class="col-md-5 text-end">
                            <img src="<?php echo asset('assets') ?>/img/monitor-3.png" class="img-fluid" alt="Monitors">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Aircon -->
            <div class="col-lg-6" data-aos="zoom-in" data-aos-delay="200">
                <div class="category-card bg-teal text-white">
                    <div class="row align-items-center h-100">
                        <div class="col-md-7">
                            <h3>Aircon</h3>
                            <p>Beat the heat, Stay cool!</p>
                            <a href="#" class="btn btn-outline-light">See All</a>
                        </div>
                        <div class="col-md-5 text-end">
                            <img src="<?php echo asset('assets') ?>/img/aircon.png" class="img-fluid" alt="Aircon">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Small Appliances -->
            <div class="col-lg-6" data-aos="zoom-in" data-aos-delay="300">
                <div class="category-card bg-teal text-white">
                    <div class="row align-items-center h-100">
                        <div class="col-md-7">
                            <h3>Small Appliances</h3>
                            <p>Small Appliances for Offices</p>
                            <a href="#" class="btn btn-outline-light">See All</a>
                        </div>
                        <div class="col-md-5 text-end">
                            <img src="<?php echo asset('assets') ?>/img/small-appliances.png" class="img-fluid" alt="Appliances">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Accessories -->
            <div class="col-lg-6" data-aos="zoom-in" data-aos-delay="100">
                <div class="category-card bg-sand">
                    <div class="row align-items-center h-100">
                        <div class="col-md-7">
                            <h3>Accessories</h3>
                            <p>Accessories for your every need!</p>
                            <a href="#" class="btn btn-outline-dark">See All</a>
                        </div>
                        <div class="col-md-5 text-end">
                            <img src="<?php echo asset('assets') ?>/img/accessories.png" class="img-fluid" alt="Accessories">
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <section class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="row g-4">
            <h1 class="text-center hfive">Our Brands</h1>
            <p class="text-center">Palaniappa Electornics offers a wide range of trusted brands to choose from.</p>
            <img src="<?= asset('assets/img/') ?>/brand.png" />
        </div>
    </section>


    @endsection