 @extends('backend.app_template')
@section('title','Meta Store or Update')
@section('content')
 <?php 
 $id                = isset($record->id) ? $record->id:'';
 $meta_title      = isset($record->meta_title) ? $record->meta_title:''; 
 $meta_keywords             = isset($record->meta_keywords) ? $record->meta_keywords:''; 
 $meta_description           = isset($record->meta_description) ? $record->meta_description:''; 
 $type              = ($id == '')   ? 'Create':'Update';
 
 ?>
 <main class="app-wrapper">
            <div class="container-fluid">

                <div class="d-flex align-items-center mt-2 mb-2">
                    
                    <div class="flex-shrink-0">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-end mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0)">Meta</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?= $type ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-12 col-xxl-12">
                        <form method="POST" id="countryForm" action="<?= route('storeUpdateMeta') ?>" enctype="multipart/form-data">
                           @csrf
                            <div>
                                <div class="card">
                                    <span></span>
                                    <!-- Logistics Details Section -->
                                    <div class="card-header">
                                        <h5 class="mb-0"><?= $type ?> Meta</h5>
                                        <div class="float-end">
                                            <a href="<?=  route('meta') ?>" class="btn btn-primary" >Back</a>
                                        </div>
                                    </div>
                                    <input type="hidden" name="id" value="<?= $id ?>" />
                                    <div class="card-body">
                                        <div class="row g-4">
                                           
                                              <div class="col-xl-6">
                                                 <label for="name" class="form-label">Meta Title</label>
                                                 <textarea required class="form-control" id="meta_title" name="meta_title" rows="6"><?= $meta_title ?></textarea>
                                            </div>
                                            
                                             <div class="col-xl-6">
                                                 <label for="name" class="form-label">Meta Keywords (keywords comma seperated)</label>
                                                 <textarea required class="form-control" id="meta_keywords" name="meta_keywords" placeholder="meta,keyword" rows="6"><?= $meta_keywords ?></textarea>
                                            </div>
                                            <div class="col-xl-12">
                                                 <label for="name" class="form-label">Meta Description</label>
                                                 <textarea required class="form-control" id="meta_description" name="meta_description" rows="6"><?= $meta_description ?></textarea>
                                            </div>                             
                                        </div>

                                    </div>
                                </div>                               
                            </div>
                            <div class="d-flex justify-content-end gap-3 my-5">
                                <a href="" class="btn btn-light-light text-muted">Cancel</a>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                   
                </div>
                <!-- Submit Section -->
            </div>
        </main>
        <script type="text/javascript" src="//cdn.ckeditor.com/4.5.1/standard/ckeditor.js"></script>
    <script>

        		CKEDITOR.config.versionCheck = false;
		 CKEDITOR.replace('meta_title');
		 CKEDITOR.replace('meta_keywords');
		 CKEDITOR.replace('meta_description');

        $(function() {
       $("#countryForm").validate({
         rules: {
           type: {  required: true },
           title: {  required: true },           
        
         },
         messages: {
           type: { required: "Please choose type" },          
           title: { required: "Please enter title" },          
         },
         errorElement: "span",
         errorPlacement: function(error, element) {
           error.addClass("text-danger");
           error.insertAfter(element);
         }
       });
     });
    </script>    
@endsection