<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\BodyTypeModel;

use Illuminate\Http\Request;

class BodyTypeController extends Controller
{
     public function index()
    {
        //dd("list");
        $records   =  BodyTypeModel::orderBy('body_type', 'ASC')->get();
        return view('backend.bodyType.list', compact('records'));
    }

    public function BodyTypeDetails($id = '')
    {
      
        $record = '';
        if ($id > 0) {
            $record = BodyTypeModel::WHere('id', $id)->first();
        }
        return view('backend.bodyType.add_edit', compact('record'));
    }

    public function storeUpdateBodyType(Request $request)
    {
        $input     = $request->all();
        $id        = isset($input['id']) ? $input['id'] : 0;

        $dataArr = [];
        foreach ($input as $key => $val) {
            if ($key != '_token' && $key != 'id' )
                $dataArr[$key] = $val;
        }

       
        if ($id == 0 || $id == '') {
            $request->validate([
                'body_type'          =>  "required|unique:body_type,body_type",
              
            ]);
           $insert = BodyTypeModel::create($dataArr);
           if($insert['id'] > 0)
           {
               return redirect()->route('bodyType')->with('success', 'Body Type Saved Successfully');
           }else{
               return redirect()->route('bodyType')->with('error', 'Something went wrong!');
           }
           
        } else {
            $request->validate([
                'body_type'          =>  "required",               
            ]);
            $update = BodyTypeModel::Where('id',$id)->update($dataArr);
            return redirect()->route('bodyType')->with('success', 'Body Type Updated Successfully');;
        }        
    }
}
