@extends('app_layout')
@section('title','Contact Us')
@section('content')
<main class="main">
    <div class="page-title ">
        <div class="container mt-2">
            <div class="row g-4">
                <div class="col-lg-7">
                    <?php
                   
                    $image = isset($productItems[0]->product_image) ? $productItems[0]->product_image : '';
                    ?>
                    <div class="service-image-block">
                        <img src="<?= $image ?>" alt="Construction Services" class="img-fluid">
                    </div>
                </div>
                <div class="col-lg-5">
                    <nav class="breadcrumbs d-flex">
                        <ol>
                            <li><a href="<?= route('/') ?>">Home</a></li>
                            <li><a href="#"><?= $record->category->category_name ?></a></li>
                            <li><a href="<?= route('products', [$record->product_slug]) ?>"><?= ucwords($record->product_name) ?></a></li>
                        </ol>
                    </nav>
                    <div class="container py-4">
                        <div class="row g-4">
                            <h3 class="htitle "><?= ucwords($record->product_name) ?></h3>
                            <p>{!! $record->product_description !!}</p>
                            <div class="d-flex">
                                <a href="javascript:void(0)" onclick="showForm('enquiryForm','catalogForm')"><span  class="enquiry">Enquiry Now</span></a>&nbsp;
                                <a href="javascript:void(0)" onclick="showForm('catalogForm','enquiryForm')"><span class="enquiry">Download Catalogue</span></a>
                            </div>
                            <form action="" method="post" class="enquiryForm">
                                <label>Fields marked with an * are required</label>
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control form-bord" id="nameInput" name="name" placeholder="Name" required="">
                                    <label for="nameInput"> Name *</label>
                                </div>

                                <div class="form-floating mb-3">
                                    <input type="email" class="form-control form-bord" id="emailInput" name="email" placeholder="Email Address" required="">
                                    <label for="emailInput">Email *</label>
                                </div>

                                <div class="form-floating mb-3">
                                     <input type="text" class="form-control form-bord" id="emailInput" name="phone" placeholder="Phone" required="">
                                    <label for="messageInput">Phone *</label>
                                </div>
                                <div class="d-grid mt-5">
                                    <button type="submit" class="btnsubmit">Submit</button>
                                </div>
                            </form>
                             <form action="" method="post" class="catalogForm">
                                
                                <label>Fields marked with an * are required</label>
                                <div class="form-floating mb-3">
                                     <input type="text" class="form-control form-bord" id="emailInput" name="phone" placeholder="Phone" required="">
                                    <label for="messageInput">Phone *</label>
                                </div>
                                <div class="d-grid mt-5">
                                    <button type="submit" class="btnsubmit">Submit</button>
                                </div>
                            </form>
                            <div class="mb-1">
                                <h6 class=" text-muted">Brand</h6>
                                <?php foreach($brands as $val){ ?>
                                     <a href="javascript:void(0)" ><span data-toggle="tooltip"  title="<?= $val->brand ?>"  data-placement="top" class="tag-box-brand"><?= $val->brand ?></span></a>
                                <?php } ?>
                                <input name="brand" type="hidden" id="filter-brand" />
                            </div>

                            <hr>

                            <div class="mb-1">
                                <h6 class=" text-muted">Size/Range/Capacity</h6>
                                <div class="d-flex flex-wrap gap-2">
                                    <?php foreach($size as $val){ ?>
                                    <a href="javascript:void(0)" ><span data-toggle="tooltip"  title="<?= $val->size ?>"  data-placement="top" class="tag-box-size"><?= $val->size ?></span></a>                                    
                                    <?php } ?>
                                   
                                </div>
                            </div>

                            <hr>
 
                            <div class="mb-1">
                                <h6 class=" text-muted">Industry</h6>
                                <div class="d-flex flex-wrap gap-2">
                                    <?php foreach($industrys as $val){ ?>
                                    <a href="javascript:void(0)" ><span data-toggle="tooltip"  title="<?=  $val->industry ?>"  data-placement="top" class="tag-box-indus"><?=  ucwords($val->industry) ?></span></a>                                   
                                    <?php } ?>
                                   
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('.catalogForm , .enquiryForm').hide();

        function showForm(showid,hideid)
        {
            $('.'+showid).show();
            $('.'+hideid).hide();
        }

     
    </script>
    @endsection