<?php

use App\Http\Controllers\Api\AuthController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('login', [AuthController::class, 'login'])->name('login');
Route::post('register', [AuthController::class, 'register'])->name('register');
Route::get('forget-password-otp', [AuthController::class, 'forgetPasswordOTP'])->name('forget-password-otp');
Route::get('check-otp', [AuthController::class, 'checkOTP'])->name('check-otp');
Route::post('support-request', [AuthController::class, 'support_request'])->name('support-request');
Route::get('notification-push', [AuthController::class, 'triggerNotification'])->name('notification-push');

Route::middleware(['checksession'])->group(function () 
{


// Route::get('updateImageurl', [AuthController::class, 'updateImageurl'])->name('updateImageurl');

Route::post('create-user-vedio', [AuthController::class, 'createUserVedio'])->name('create-user-vedio');
Route::get('get-user-vedio', [AuthController::class, 'getUserVedio'])->name('get-user-vedio');
Route::get('get-user-details', [AuthController::class, 'getUserDetails'])->name('get-user-details');
Route::post('update-profile', [AuthController::class, 'updateProfile'])->name('update-profile');
Route::post('update-country', [AuthController::class, 'updateCountry'])->name('update-country');
Route::post('update-password', [AuthController::class, 'updatePassword'])->name('update-password');
Route::post('change-password', [AuthController::class, 'changePassword'])->name('change-password');

Route::post('add-country', [AuthController::class, 'addCountry'])->name('add-country');
Route::get('get-all-countries', [AuthController::class, 'getAllCountries'])->name('get-all-countries');

Route::post('add-service', [AuthController::class, 'addService'])->name('add-service');
Route::post('add-personal-details', [AuthController::class, 'addPersonalDetails'])->name('add-personal-details');
Route::post('add-advertisement', [AuthController::class, 'addAdvertisement'])->name('add-advertisement');

Route::post('edit-service', [AuthController::class, 'editService'])->name('edit-service');
Route::post('edit-personal-details', [AuthController::class, 'editPersonalDetails'])->name('edit-personal-details');
Route::post('edit-advertisement', [AuthController::class, 'editAdvertisement'])->name('edit-advertisement');

Route::get('service-list', [AuthController::class, 'getServiceList'])->name('service-list');
Route::get('service-type', [AuthController::class, 'getServiceTypeList'])->name('service-type');
Route::get('ads-list', [AuthController::class, 'getAdsList'])->name('ads-list');
Route::get('ads-details', [AuthController::class, 'getAdsDetails'])->name('ads-details');
Route::get('ads-delete', [AuthController::class, 'deleteAds'])->name('ads-delete');
Route::get('ads-change-status', [AuthController::class, 'adsChangeStatus'])->name('ads-change-status');


Route::get('get-all-master-data', [AuthController::class, 'getAllMasterDatas'])->name('get-all-master-data');
Route::get('get-all-language', [AuthController::class, 'getAllLanguage'])->name('get-all-language');

Route::get('get-dashboard-list', [AuthController::class, 'getdashboardList'])->name('get-dashboard-list');
Route::post('manage-request', [AuthController::class, 'manageRequest'])->name('manage-request');
Route::get('serviceList', [AuthController::class, 'serviceList'])->name('serviceList');

Route::get('get-accepted-list', [AuthController::class, 'getAccepetedList'])->name('get-accepted-list');
Route::post('upload-vedio', [AuthController::class, 'uploadVedio'])->name('upload-vedio');
Route::get('verify-vedio', [AuthController::class, 'vedioVerify'])->name('verify-vedio');
Route::post('/logout', [AuthController::class, 'logout']);

});
