@extends('app_layout')
@section('title','Contact Us')
@section('content')
<main class="main">
    <div class="page-title ">
        <div class="container mt-2">
            <div class="row g-4">
                <div class="col-lg-7">
                    <?php

                    $image = isset($productItems[0]->product_image) ? $productItems[0]->product_image : '';
                    ?>
                    <div class="service-image-block">
                        <a href="<?php echo $image ?>" data-zoomable="true" class="glightbox"><img src="<?php echo $image ?>" alt="Construction Services" class="img-fluid"></a>
                    </div>
                </div>
                <div class="col-lg-5">
                    <nav class="breadcrumbs d-flex">
                        <ol>
                            <li><a href="<?php echo route('/') ?>">Home</a></li>
                            <li><a href="#"><?php echo $record->category->category_name ?></a></li>
                            <li><a href="<?php echo route('products', [$record->product_slug]) ?>"><?php echo ucwords($record->product_name) ?></a></li>
                        </ol>
                    </nav>
                    <div class="container py-4">
                        <div class="row g-4">
                            <h3 class="htitle "><?php echo ucwords($record->product_name) ?></h3>
                            <p>{!! $record->product_description !!}</p>
                            <div class="d-flex">
                                <a href="javascript:void(0)" onclick="showForm('enquiryForm','catalogForm')"><span class="enquiry">Enquiry Now</span></a>&nbsp;
                                <a href="javascript:void(0)" onclick="showForm('catalogForm','enquiryForm')"><span class="enquiry">Download Catalogue</span></a>
                            </div>
                            <form action="#" method="post" class="enquiryForm">
                                @csrf
                                <label>Fields marked with an * are required</label>
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control form-bord" id="nameInput" name="name" placeholder="Name" required="">
                                    <label for="nameInput"> Name *</label>
                                </div>

                                <div class="form-floating mb-3">
                                    <input type="email" class="form-control form-bord" id="emailInput" name="email" placeholder="Email Address" required="">
                                    <label for="emailInput">Email *</label>
                                </div>

                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control form-bord" id="phone" name="phone" placeholder="Phone" required="">
                                    <label for="messageInput">Phone *</label>
                                </div>
                                <input name="brand" type="hidden" id="filter-brand" name="filter-brand" />
                                <input name="size" type="hidden" id="filter-size" name="filter-size" />
                                <input name="industry" type="hidden" id="filter-industry" name="filter-industry" />
                                <div class="d-grid mt-5">
                                    <button type="submit" class="btnsubmit">Submit</button>
                                </div>
                            </form>
                            <form action="" method="post" class="catalogForm">
                                @csrf
                                <label>Fields marked with an * are required</label>
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control form-bord" id="emailInput" name="phone" placeholder="Phone" required="">
                                    <label for="messageInput">Phone *</label>
                                </div>
                                <div class="d-grid mt-5">
                                    <button type="submit" class="btnsubmit">Submit</button>
                                </div>
                            </form>
                            <div id="link">
                                
                            </div>
                            <div class="mb-1">
                                <h6 class=" text-muted">Brand</h6>
                                <?php foreach ($brands as $val) { ?>
                                    <a onclick="filterBrand('<?= $val->id ?>')" href="javascript:void(0)"><span data-toggle="tooltip" title="<?php echo $val->brand ?>" data-placement="top" class="tag-box-brand"><?php echo $val->brand ?></span></a>
                                <?php } ?>

                            </div>

                            <hr>

                            <div class="mb-1">
                                <h6 class=" text-muted">Size/Range/Capacity</h6>
                                <div class="d-flex flex-wrap gap-2">
                                    <?php foreach ($size as $val) { ?>
                                        <a onclick="filterSize('<?= $val->id ?>')" href="javascript:void(0)"><span data-toggle="tooltip" title="<?php echo $val->size ?>" data-placement="top" class="tag-box-size"><?php echo $val->size ?></span></a>
                                    <?php } ?>

                                </div>
                            </div>

                            <hr>

                            <div class="mb-1">
                                <h6 class=" text-muted">Industry</h6>
                                <div class="d-flex flex-wrap gap-2">
                                    <?php foreach ($industrys as $val) { ?>
                                        <a onclick="filterIndustry('<?= $val->id ?>')" href="javascript:void(0)"><span data-toggle="tooltip" title="<?php echo $val->industry ?>" data-placement="top" class="tag-box-indus"><?php echo ucwords($val->industry) ?></span></a>
                                    <?php } ?>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('.catalogForm , .enquiryForm').hide();

        function showForm(showid, hideid) {
            $('.' + showid).show();
            $('.' + hideid).hide();
        }


        $(function() {
            $(".enquiryForm").validate({
                rules: {
                    name: {
                        required: true,
                        minlength: 3
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    phone: {
                        required: true,
                        digits: true,
                        maxlength: 10,
                        minlength: 10
                    },

                },
                messages: {
                    name: {
                        required: "please enter name",
                        minlength: "name must be at least 3 characters"
                    },
                    email: {
                        required: "email is required",
                        email: "please enter a valid email address"
                    },
                    phone: {
                        required: "phone number is required",
                        digits: "only numbers are allowed",
                        minlength: "phone number must be 10 digits",
                        maxlength: "phone number must be 10 digits"
                    },
                },
                errorElement: "span",
                errorPlacement: function(error, element) {
                    error.addClass("text-danger");
                    error.insertAfter(element);
                },
                submitHandler: function(form) {
                    $.ajax({
                        url: '<?=  route('submit-enquiry') ?>',
                        type: "POST",
                        data: $(form).serialize(),
                        dataType: "json",
                        beforeSend: function() {
                            $(form).find("button[type=submit]").prop("disabled", true);
                             $(form).find("button[type=submit]").text("Loading...");
                        },
                        success: function(response) {
                            alert("Enquiry Submiited.");
                             $('.enquiryForm')[0].reset();
                             $('.enquiryForm').hide();
                        },
                        error: function() {
                            alert("Server error. Please try again.");
                        },
                        complete: function() {
                            $(form).find("button[type=submit]").prop("disabled", false);
                             $(form).find("button[type=submit]").text("Submit");
                        }
                    });
                    return false;
                }
            });

            $(".catalogForm").validate({
                rules: {

                    phone: {
                        required: true,
                        digits: true,
                        maxlength: 10,
                        minlength: 10
                    },

                },
                messages: {
                    phone: {
                        required: "phone number is required",
                        digits: "only numbers are allowed",
                        minlength: "phone number must be 10 digits",
                        maxlength: "phone number must be 10 digits"
                    },
                },
                errorElement: "span",
                errorPlacement: function(error, element) {
                    error.addClass("text-danger");
                    error.insertAfter(element);
                },
                submitHandler: function(form) {
                    $.ajax({
                        url: '<?=  route('download-catalog') ?>',
                        type: "POST",
                        data: $(form).serialize(),
                        dataType: "json",
                        beforeSend: function() {
                            $(form).find("button[type=submit]").prop("disabled", true);
                            $(form).find("button[type=submit]").text("Loading...");
                        },
                        success: function(response) {
                              //  var row = JSON.parse(response);
                                if(response.status == 1)
                                {
                                    $('#link').html(response.link);
                                    $('.catalogForm').hide();
                                     $('.catalogForm')[0].reset(); 
                                }
                        },
                        error: function() {
                            alert("Server error. Please try again.");
                        },
                        complete: function() {
                            $(form).find("button[type=submit]").prop("disabled", false);
                            $(form).find("button[type=submit]").text("Submit");
                        }
                    });
                    return false;
                }
            });
        });

         function filterIndustry(id)
        {
            $('#filter-industry').val(id);            
        }
        function filterSize(id)
        {
            $('#filter-size').val(id);            
        }
        function filterBrand(id)
        {
            $('#filter-brand').val(id);            
        }
    </script>
    @endsection