@extends('app_layout')
@section('title','Contact Us')
@section('content')
<main class="main">
    <div class="page-title ">
        <div class="container">
            <div class="row g-4">
                <h1 class="hfive text-center">Products</h1>
                <div class="col-lg-4">
                    <div class="accordion filter-accordion" id="filterAccordion">

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#type"
                                    aria-expanded="true">
                                    FILTER BY PRODUCT TYPE
                                </button>
                            </h2>
                            <div id="type" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <?php if (isset($productType)) {
                                        foreach ($productType as $row) { ?>
                                            <div onclick="filterCatgory('<?= $row->id ?>')"><?php echo $row->category_name ?></div>
                                    <?php }
                                    } ?>
                                </div>
                                 <input name="category" type="hidden" id="filter-category" />
                                 <input name="category_slug" type="hidden" id="category_slug" value="<?= request('prodcat') ?>" />
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#industry"
                                    aria-expanded="true">
                                    FILTER BY INDUSTRY
                                </button>
                            </h2>
                            <div id="industry" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <?php if (isset($industryData)) {
                                        foreach ($industryData as $row) { ?>
                                            <div onclick="filterIndustry('<?= $row->id ?>')"><?php echo $row->industry ?></div>
                                    <?php }
                                    } ?>
                                </div>
                                 <input name="industry" type="hidden" id="filter-industry" />
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#brand"
                                    aria-expanded="true">
                                    FILTER BY BRAND
                                </button>
                            </h2>
                            <div id="brand" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <?php if (isset($brandData)) {
                                        foreach ($brandData as $row) { ?>
                                            <div onclick="filterBrand('<?= $row->id ?>')" ><?php echo $row->brand ?></div>
                                    <?php }
                                    } ?>
                                </div>
                                 <input name="brand" type="hidden" id="filter-brand" />

                            </div>
                        </div>

                    </div>

                </div>
                <div class="col-lg-8">
                    <div class="container py-4">
                        <div class="row g-4" id="productList">

                        </div>

                        <div class="text-center mt-4">
                            <span id="loadMore" class="btn et-loader"></span>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {

            $('.filter-accordion .accordion-body div').on('click', function() {
                $(this)
                    .closest('.accordion-body')
                    .find('div')
                    .removeClass('active');
                $(this).addClass('active');

            });

        });


        let offset = 0;
        const limit = 6;
        $('#loadMore').hide();

        function loadProducts(reset = false) {

            if (reset) {
                offset = 0;
                $('#productList').html('');
            }
            $('#loadMore').show();
             var industry = $('#filter-industry').val();
             var category = $('#filter-category').val();
             var brand = $('#filter-brand').val();
             var category_slug = $('#category_slug').val();
             
            $.ajax({
                url: '<?php echo route('getProducts') ?>',
                type: 'GET',
                data: {
                    offset: offset,
                    limit: limit,
                    industry: industry,
                    category: category,
                    brand: brand,
                    category_slug:category_slug
                },
                success: function(data) {

                    // if (data.length === 0) {
                    //     $('#loadMore').hide();
                    //     return;
                    // }
                    $('#loadMore').hide();
                    $('#productList').append(data);
                    offset += limit;
                }
            });
        }

        // Initial Load
        loadProducts();

        $(window).on('scroll', function() {
            if (
                $(window).scrollTop() + $(window).height() >=
                $(document).height() - 100
            ) {
                loadProducts();
            }
        });

        // Load More Click
        // $('#loadMore').on('click', function () {
        //     loadProducts();
        // });

           function filterIndustry(id)
        {
            $('#filter-industry').val(id);
            loadProducts(true);
        }
        function filterCatgory(id)
        {
            $('#filter-category').val(id);
            loadProducts(true);
        }
        function filterBrand(id)
        {
            $('#filter-brand').val(id);
            loadProducts(true);
        }
    </script>


    @endsection