@extends('backend.app_template')
@section('title','Meta List')
@section('content')
<main class="app-wrapper">
    <div class="container-fluid">

        <div class="d-flex align-items-center mt-2 mb-2">
            <div class="flex-shrink-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-end mb-0">
                        <li class="breadcrumb-item"><a href="javascript:void(0)">Meta</a></li>
                        <li class="breadcrumb-item active" aria-current="page">List</li>
                    </ol>
                </nav>                
            </div>
        </div>

        <div class="row">
            <?php if($cont == 0){ ?>
            <div class="d-flex justify-content-end mb-4">
                <a href="<?php echo route('addMeta') ?>" class="btn btn-primary">Add Meta</a>
            </div>    
            <?php } ?>       
            <table id="datatables" class="table table-nowrap table-hover table-bordered w-100 mt-5">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Meta Title</th>                       
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (isset($records)) {
                        $i = 1;
                        foreach ($records as $key => $row) {
                    ?>
                            <tr>
                                <td><?php echo $i ?></td>                           
                                <td><?php echo $row->meta_title ?></td>                                                              
                                <td>
                                    <a data-toggle="tooltip" data-placement="top" title="Edit" href="<?php echo route('addMeta', [$row->id]) ?>" class="btn btn-sm btn-warning"><i class="bi bi-pencil-fill"></i></a>
                                    <a data-toggle="tooltip" data-placement="top" title="Delete" data-original-title="Delete" href="javascript:void(0)" onclick="commonDelete('<?php echo $row->id ?>','MetaModel')" class="btn btn-sm btn-danger"><i class="bi bi-trash-fill"></i></a>
                                </td>
                            </tr>

                    <?php $i++;
                        }
                    } ?>

                </tbody>
            </table>
        </div>
        <!-- Submit Section -->
    </div>
</main>
@endsection