<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class CommonController extends Controller
{
      public function updateCommonStatus(Request $request)
    {
        $input       = $request->all();
        $id          = $input['id'];
        $status      = $input['status'];
        $model       = 'App\\Models\\' . $input['model'];
        $updateArray = [
            'status' => $status,
        ];
        if ($input['model'] == 'States') {
            $update = $model::where('state_id', $id)->update(['is_active' => $status]);
            echo json_encode(array('status' =>1,'message'=>'Status Changed Successfully'));

        }elseif($input['model'] == 'PersonalDetails'){
            $update =    $model::Where('id',$id)->update(array('is_verified' => $status));
            echo json_encode(array('status' =>2,'message'=>($status == 2) ? 'Verify Successfully':'Reject Successfully'));
        }else if($input['model'] == 'UserVedio'){

            $model::query()->update(['status' => 0]);
            $model::where('id', $id)->update(['status' => 1]);
            echo json_encode(array('status' =>1,'message'=>'Status Changed Successfully'));


        }else {

            $update = $model::where('id', $id)->update($updateArray);

            echo json_encode(array('status' =>1,'message'=>'Status Changed Successfully'));
        }
    }


    public function commonDelete(Request $request)
    {
        $input  = $request->all();
        $id     = $input['id'];
        $model  = 'App\\Models\\' . $input['model'];
        $update = $model::where('id', $id)->delete();
        if ($update) {
            echo 1;
        }
    }

    public function profile()
    {
        $userId    = Auth::user()->id;
        $record    = User::Where('id', $userId)->first();
        return view('backend.profile', compact('record'));
    }

    public function saveProfile(Request $request)
    {

        $input = $request->all();
        $data  = [];
        foreach ($input as $key => $val) {
            if ($key != 'id' && $key != "_token") {
                $data[$key] = $val;
            }
        }

        $id = $input['id'] ?? '';

         $update = User::whereId($id)->update($data);
        //  $msg =  "Profile was Updated By ";
        //  if (!$this->storeLog($msg)) {}
        return redirect()->back()->with('success', 'Profile Updated');
    }

    public function changePassword(Request $request)
    {
        $input   = $request->all();
        $passwd  = $input['password'] ?? '';
        $cpasswd = $input['cpassword'] ?? '';
        $id      = $input['id'] ?? '';
        if ($passwd == $cpasswd) {
            $pwd    = Hash::make($passwd);
            $update = User::whereId($id)->update(['password' => $pwd]);
            //   $msg =  "Password was Updated By ";
            //  if (!$this->storeLog($msg)) {}
            return redirect()->back()->with('success', 'Password Updated');
        } else {

            return redirect()->back()->with('error', 'Password Not Matched');
        }
    }
}
