<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Settings;

use Illuminate\Http\Request;

class SettingsController extends Controller
{


    public function settings($id = '')
    {
        $record = Settings::Where('id', 1)->first();
        return view('backend.settings.add_edit', compact('record'));
    }

    public function storeSettings(Request $request)
    {
        $input     = $request->all();

        $dataArr = [];
        foreach ($input as $key => $val) {
            if ($key != '_token' && $key != 'id')
                $dataArr[$key] = $val;
        }

        $request->validate([
            'app_time'          =>  "required",
            'web_time'          =>  "required",
        ]);
         Settings::Where('id', 1)->update($dataArr);
        return redirect()->route('settings')->with('success', 'Updated Successfully');;
    }
}
