<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\AdReport;
use App\Models\Advertisement;
use App\Models\LanguageModel;
use App\Models\PersonalDetails;
use App\Models\Service;
use App\Models\ServiceRequest;
use App\Models\ServiceTypeModel;
use App\Models\Support;
use App\Models\User;
use App\Models\WebRequestModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportsController extends Controller
{
  public function web_request(Request $request)
  {
    $input = $request->all();
    $user  = isset($input['user']) ? $input['user'] : 0;
    $service  = isset($input['service']) ? $input['service'] : 0;
    $type  = isset($input['type']) ? $input['type'] : 0;
    $usersData = User::Where('auth_level', 2)->get();
    $serviceData = ServiceTypeModel::Where('status', 1)->get();

    $data = WebRequestModel::query()
      ->select([
        'u.name',
        'st.service_type',
        'web_request.availability',
        'web_request.location',
        'web_request.request_id',
        'web_request.language',
        'mr.type'
      ])
      ->leftJoin('manage_request as mr', 'mr.request_id', '=', 'web_request.request_id')
      ->leftJoin('users as u', 'u.id', '=', 'mr.user_id')
      ->leftJoin('service_type as st', 'st.id', '=', 'web_request.service_type')
      ->whereNotNull('mr.type');

    if ($user != '' && $user > 0) {
      $data->Where('mr.user_id', $user);
    }

    if ($type != '' && $type > 0) {
      $data->Where('mr.type', $type);
    }

    if ($service != '' && $service > 0) {
      $data->Where('web_request.service_type', $service);
    }
    $results = $data->get();
    $records = [];

    foreach ($results as $val) {
      $langIds = explode(',', $val->language);
      $val->language_names = LanguageModel::whereIn('id', $langIds)->pluck('name')->implode(', ');
      $records[] = $val;
    }


    return view('backend.reports.web_request', compact('type', 'records', 'usersData', 'serviceData', 'service', 'user'));
  }


  public function customers(Request $request)
  {
    $input = $request->all();
    $service  = isset($input['service']) ? $input['service'] : 0;
    $serviceData = ServiceTypeModel::Where('status', 1)->get();


    $data = ServiceRequest::query()
      ->from('service_requests as sr')
      ->select(
        'sr.customer_id',
        'sr.request_id',
        'sr.number',
        'st.service_type',
        'wr.location',
        'wr.day_rate_min',
        'wr.day_rate_max',
        'wr.night_rate_min',
        'wr.night_rate_max',
        'wr.availability',
        'sr.created_at',
        'sr.number as contact_number'
      )
      ->leftJoin('web_request as wr', 'wr.request_id', '=', 'sr.request_id')
      ->leftJoin('service_type as st', 'st.id', '=', 'wr.service_type');

    if ($service != '' && $service > 0) {
      $data->Where('sr.service_request_type_id', $service);
    }
    $records = $data->get();



    return view('backend.reports.customer', compact('records', 'serviceData', 'service'));
  }


  public function adsManagement(Request $request)
  {

    $input     = $request->all();

    $service  = isset($input['service']) ? $input['service'] : 0;
    $from  = isset($input['from']) ? $input['from'] : '';
    $serviceData = ServiceTypeModel::Where('status', 1)->get();
    if ($from != '') {
      $fromDate = date('Y-m-d', strtotime(explode(" - ", $from)[0]));
      $toDate   = date('Y-m-d', strtotime(explode(" - ", $from)[1]));
    }

    $data = Advertisement::query()
      ->from('advertisement as a')
      ->select('a.id', 's.title as name', 'st.service_type', 'a.phone', 'a.created_at', 'a.status', 'a.service_id')
      ->leftJoin('service as s', 's.id', '=', 'a.service_id')
      ->leftJoin('service_type as st', 'st.id', '=', 's.service_type');

    if ($service != '' && $service > 0) {
      $data->Where('st.id', $service);
    }

    if ($from != '') {
      $data->whereBetween('a.created_at', [$fromDate, $toDate]);
    }

    $records = $data->get();
    return view('backend.reports.ads_management', compact('records', 'serviceData', 'service','from'));
  }


  public function adsVerification(Request $request)
  {

    $input     = $request->all();

    $service  = isset($input['service']) ? $input['service'] : 0;
    $from  = isset($input['from']) ? $input['from'] : '';
    $serviceData = ServiceTypeModel::Where('status', 1)->get();
    if ($from != '') {
      $fromDate = date('Y-m-d', strtotime(explode(" - ", $from)[0]));
      $toDate   = date('Y-m-d', strtotime(explode(" - ", $from)[1]));
    }

    $data = Advertisement::query()
      ->from('advertisement as a')
      ->select('pd.id', 'pd.is_verified', 'pd.vedio', 's.title as name', 'st.service_type', 'a.phone', 'a.created_at', 'a.status', 'a.service_id')
      ->leftJoin('service as s', 's.id', '=', 'a.service_id')
      ->leftJoin('service_type as st', 'st.id', '=', 's.service_type')
      ->leftJoin('personal_details as pd', 'pd.id', '=', 'a.service_id')
      ->Where('pd.is_verified', 1)
      ->WhereNotNull('pd.vedio');

    if ($service != '' && $service > 0) {
      $data->Where('st.id', $service);
    }

    if ($from != '') {
      $data->whereBetween('a.created_at', [$fromDate, $toDate]);
    }

    $records = $data->get();
    return view('backend.reports.ads_verification', compact('records', 'serviceData', 'service','from'));
  }


  public function reportedAds(Request $request)
  {
    $input     = $request->all();

    $service  = isset($input['service']) ? $input['service'] : 0;
    $from     = isset($input['from']) ? $input['from'] : '';
    if ($from != '') {
      $fromDate = date('Y-m-d', strtotime(explode(" - ", $from)[0]));
      $toDate   = date('Y-m-d', strtotime(explode(" - ", $from)[1]));
    }

    $data = AdReport::query()
      ->from('ad_reports as a');
    if ($from != '') {
      $data->whereBetween('a.created_at', [$fromDate, $toDate]);
    }

    $records = $data->get();
    return view('backend.reports.report_ad', compact('records','from','service'));
  }


  public function generalSupport(Request $request)
  {
    $input     = $request->all();
    $data = Support::query()->from('support as a');
    $records = $data->get();

    return view('backend.reports.general_support', compact('records'));
  }


  public function updateSupportStatus(Request $request)
  {
    $id   = $request->id;
    $status = $request->status;
    $type = $request->type;
    if ($id != '' && $id > 0) {
      Support::Where('id', $id)->update(array('status' => $status));
    }
    // $arr = array(0=>'all',1=>'unreview',2=>'resolved','3'=>'closed');
    $arr1 = array('all' => 0, 'unreview' => 1, 'resolved' => 2, 'closed' => 3);
    echo $arr1[$type];
  }

  public function getSupport(Request $request)
  {

    $type = $request->type;
    $status = $request->status;


    $data = Support::query()->from('support as a');
    if ($status != 0) {
      $data->Where('status', $status);
    }
    $records = $data->get();
    $tr = "";

    if (!empty($records)) {
      $i = 1;
      foreach ($records as $row) {

        $tr .= "<tr>";

        $tr .= "<td>{$i}</td>";
        $tr .= "<td>{$row->email}</td>";
        $tr .= "<td>{$row->mobile}</td>";

        // Issues button
        $tr .= "<td>
                    <a href='javascript:void(0)' onclick=\"showIssues('" . htmlspecialchars($row->issue, ENT_QUOTES) . "')\" class='badge bg-pill bg-danger'>
                        <i class='bi bi-eye'></i> View
                    </a>
                </td>";

        // Images button
        $tr .= "<td>
                    <a href='javascript:void(0)' class='badge bg-pill bg-danger'>
                        <i class='bi bi-eye'></i> View
                    </a>
                </td>";

        // Status select
        $tr .= "<td>
                    <select class='form-control' id='status{$row->id}' onchange=\"changeSupportChanges(this.value, '{$row->id}','{$type}')\">
                        <option class='bg-warning' " . ($row->status == 1 ? 'selected' : '') . " value='1'>Under review</option>
                        <option class='bg-success' " . ($row->status == 2 ? 'selected' : '') . " value='2'>Resolved</option>
                        <option class='bg-info' " . ($row->status == 3 ? 'selected' : '') . " value='3'>Closed</option>
                    </select>
                </td>";

        $tr .= "</tr>";

        $i++;
      }
    }
    echo $tr;
  }

  public function showDetails($id)
  {
    $results = Service::from('service as s')
      ->select(
        's.id',
        's.title',
        'st.service_type',
        's.description',
        's.photo',
        's.day_rate_min',
        's.day_rate_max',
        's.night_rate_min',
        's.night_rate_max',
        's.availability',
        's.language',
        'h.hair_color',
        'e.eye_color',
        'b.body_type',
        'o.orientation_name',
        'pd.liquor',
        'pd.bust_size',
        'pd.smoker',
        'pd.public_hair',
        'a.location',
        'pd.nationality',
        'pd.age',
        'pd.weight',
        'pd.height',
        'a.name',
        'pd.breast_type',
        'a.phone',
        'a.whatsapp',
        'a.telegram',
        'a.viber'
      )
      ->leftJoin('service_type as st', 'st.id', '=', 's.service_type')
      ->leftJoin('personal_details as pd', 'pd.service_id', '=', 's.id')
      ->leftJoin('advertisement as a', 'a.service_id', '=', 's.id')
      ->leftJoin('orientation as o', 'o.id', '=', 'pd.orientation')
      ->leftJoin('hair as h', 'h.id', '=', 'pd.hair_color')
      ->leftJoin('eye as e', 'e.id', '=', 'pd.eye_color')
      ->leftJoin('body_type as b', 'b.id', '=', 'pd.body_type')
      ->Where('s.id', $id)
      ->first();
    return view('backend.reports.show_details', compact('results'));
  }

    public function vendors(Request $request)
    {
       $input     = $request->all();
      $from     = isset($input['from']) ? $input['from'] : '';

      if ($from != '') {
        $fromDate = date('Y-m-d', strtotime(explode(" - ", $from)[0]));
        $toDate   = date('Y-m-d', strtotime(explode(" - ", $from)[1]));
      }

      $results = Service::query()
        ->from('service as s')
        ->select(
          DB::raw('COUNT(s.id) as cont'),
          's.user_id',
          'u.mobile',
          DB::raw('COUNT(CASE WHEN mr.type = 1 THEN 1 END) as accepted'),
          'u.name',
          's.id',
          'u.email',
          'u.status'
        )
        ->leftJoin('users as u', 'u.id', '=', 's.user_id')
        ->leftJoin('manage_request as mr', 'mr.service_id', '=', 's.id');

      if ($from != '') {
        $results->whereBetween('a.created_at', [$fromDate, $toDate]);
      }
      $records = $results->groupBy('s.user_id')->get();

      return view('backend.reports.vendor', compact('records','from'));
    }

    public function vendorDetails(Request $request,$id)
    {
       $input     = $request->all();
      $serviceData = ServiceTypeModel::Where('status', 1)->get();
       $from     = isset($input['from']) ? $input['from'] : '';

      if ($from != '') {
        $fromDate = date('Y-m-d', strtotime(explode(" - ", $from)[0]));
        $toDate   = date('Y-m-d', strtotime(explode(" - ", $from)[1]));
      }

      $service  = isset($input['service']) ? $input['service'] : 0;

       $results = Service::query()
              ->from('service as s')
              ->select(
                DB::raw('COUNT(s.id) as cont'),'s.user_id','u.mobile','u.name','s.id','u.email','u.status','u.created_at')
              ->leftJoin('users as u', 'u.id', '=', 's.user_id')
              ->Where('s.user_id',$id)
              // /->groupBy('s.user_id')
              ->first();
    DB::enableQueryLog();  
    $data = Advertisement::query()
      ->from('advertisement as a')
      ->select('a.id', 's.title as name', 'st.service_type', 'a.phone', 'a.created_at', 'a.status', 'a.service_id')
      ->leftJoin('service as s', 's.id', '=', 'a.service_id')
      ->leftJoin('service_type as st', 'st.id', '=', 's.service_type')
      ->Where('s.user_id',$id);

       if ($from != '') {
        $data->whereBetween('a.created_at', [$fromDate, $toDate]);
      }

       if ($service != '' && $service > 0) {
            $data->Where('s.service_type', $service);
        }
     $records = $data->get();
     

      return view('backend.reports.vendor_details', compact('service','from','records','results','serviceData'));
    }
}
