 @extends('backend.app_template')
 @section('title','Slider Store or Update')
 @section('content')
 <?php
    $id                = isset($record->id) ? $record->id : '';
    $slider_caption      = isset($record->slider_caption) ? $record->slider_caption : '';
    $slider_type      = isset($record->slider_type) ? $record->slider_type : '';
    $slider_img     = isset($record->slider_img) ? $record->slider_img : '';
    $type              = ($id == '')   ? 'Create' : 'Update';

    ?>
 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">

             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Slider</a></li>
                         <li class="breadcrumb-item active" aria-current="page"><?= $type ?></li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="col-xl-12 col-xxl-12">
                 <form method="POST" id="sliderForm" action="<?= route('storeUpdateSlider') ?>" enctype="multipart/form-data">
                     @csrf
                     <div>
                         <div class="card">
                             <span></span>
                             <!-- Logistics Details Section -->
                             <div class="card-header">
                                 <h5 class="mb-0"><?= $type ?> Slider</h5>
                                 <div class="float-end">
                                     <a href="<?= route('slider') ?>" class="btn btn-primary">Back</a>
                                 </div>
                             </div>
                             <input type="hidden" name="id" value="<?= $id ?>" />
                             <div class="card-body">
                                 <div class="row g-4">
                                     <div class="col-xl-4">
                                         <label for="slider_caption" class="form-label">Slider Caption<span class="text-danger"> *</span></label>
                                         <input type="text" value="<?= $slider_caption ?>" class="form-control" id="slider_caption" name="slider_caption" placeholder="Enter Slider Caption">
                                         @error('name') <span class="text-danger">{{$message}}</span> @enderror
                                     </div>
                                     <div class="col-xl-4">
                                         <label for="slider_type" class="form-label">Slider Type <span class="text-danger"> *</span></label>
                                         <input type="text" value="<?= $slider_type ?>" class="form-control" id="slider_type" name="slider_type" placeholder="Enter Slider Type">
                                         @error('country_code') <span class="text-danger">{{$message}}</span> @enderror
                                     </div>

                                     <div class="col-xl-4">
                                         <label for="slider_image" class="form-label">Slider Image</label>
                                         <input type="file" accept="image/png, image/jpeg,image/svg" class="form-control" name="slider_image">
                                     </div>
                                     <?php if (isset($slider_img) && $slider_img != '') { ?>
                                         <div class="col-xl-4">
                                            <label>Existing Image</label>
                                             <img height="250" width="100%" src="<?= $slider_img ?>" />
                                         </div>
                                     <?php } ?>

                                 </div>

                             </div>
                         </div>
                     </div>
                     <div class="d-flex justify-content-end gap-3 my-5">
                         <a href="" class="btn btn-light-light text-muted">Cancel</a>
                         <button type="submit" class="btn btn-primary">Save</button>
                     </div>
                 </form>
             </div>

         </div>
         <!-- Submit Section -->
     </div>
 </main>
 <script>
     $(function() {
         $("#sliderForm").validate({
             rules: {
                 slider_caption: {
                     required: true
                 },
                 slider_type: {
                     required: true
                 },
                 slider_image: {
                     required: true,
                     extension: "jpg|jpeg|png|pdf"
                 },
                 currency_code: {
                     required: true
                 },

             },
             messages: {
                 slider_caption: {
                     required: "Please enter slider caption "
                 },
                 slider_type: {
                     required: "Please enter slider caption "
                 },
                 slider_image: {
                     required: "Please Choose image"
                 },
             },
             errorElement: "span",
             errorPlacement: function(error, element) {
                 error.addClass("text-danger");
                 error.insertAfter(element);
             }
         });
     });
 </script>
 @endsection