 @extends('backend.app_template')
 @section('title','Customers')
 @section('content')
 <main class="app-wrapper">
     <div class="container-fluid">

         <div class="d-flex align-items-center mt-2 mb-2">
             <h6 class="mb-0 flex-grow-1">Customers</h6>
             <div class="flex-shrink-0">
                 <nav aria-label="breadcrumb">
                     <ol class="breadcrumb justify-content-end mb-0">
                         <li class="breadcrumb-item"><a href="javascript:void(0)">Pages</a></li>
                         <li class="breadcrumb-item active" aria-current="page">Customers</li>
                     </ol>
                 </nav>
             </div>
         </div>
         <div class="row">
             <div class="card">
                 <div class="card-body">
                     <form method="POST" action="<?= route('customers') ?>">
                        @csrf
                         <div class="row">
                             <div class="col-md-4">
                                 <label>Select Date Range</label>
                                 <input type="text" id="range-picker"  class="form-control" name="from" />
                             </div>
                             <div class="col-md-4">
                                 <label>Service Type</label>
                                 <select  class="form-control select2" id="service" name="service" >
                                     <option value="">--select--</option>
                                     <?php
                                        if (isset($serviceData)) {
                                            foreach ($serviceData as $val) { ?>
                                             <option <?php echo (isset($service) && $service == $val->id) ? 'selected' : '' ?> value="<?php echo $val->id ?>"><?php echo ucwords($val->service_type) ?></option>
                                     <?php }
                                        }
                                        ?>
                                 </select>
                             </div>
                             
                         </div>
                         <div class="d-flex mt-2">
                                <input type="submit" name="submit" value="Search" class="btn btn-primary" />
                         </div>
                         

                     </form>
                 </div>
             </div>

             <table id="datatables" class="table table-responsive   table-bordered w-100 mt-5">
                 <thead>
                     <tr>
                         <th>S.No</th>
                         <th>Date</th>
                         <th>Time</th>
                         <th>Customer ID</th>
                         <th>Service Type</th>
                         <th>Address</th>
                         <th>Short Time</th>
                         <th>Full Night</th>                        
                         <th>In/Out Call</th>  
                         <th>Contact Number</th>                      
                     </tr>
                 </thead>
                 <tbody>
                     <?php if (isset($records)) {
                            $i = 1;
                            foreach ($records as $key => $row) {
                        ?>
                             <tr>
                                 <td><?php echo $i ?></td>
                                 <td><?php echo date('d M Y',strtotime($row->created_at)) ?></td>
                                 <td><?php echo date('h:i',strtotime($row->created_at)) ?></td>
                                 <td><?php echo $row->customer_id ?></td>
                                 <td><?php echo $row->service_type ?></td>
                                 <td><?php echo $row->location ?></td>
                                 <td><?php echo $row->day_rate_min."-".$row->day_rate_max ?></td>
                                 <td><?php echo $row->night_rate_min."-".$row->night_rate_max ?></td>
                                 <td><?php echo $row->availability ?></td>                                
                                 <td><?php echo $row->contact_number ?></td>                                
                             </tr>

                     <?php $i++;
                            }
                        } ?>

                 </tbody>
             </table>
         </div>
     </div>
 </main>
 @endsection