 @extends('backend.app_template')
@section('title','Orientation Store or Update')
@section('content')
 <?php 
 $id                = isset($record->id) ? $record->id:'';
 $orientation_name              = isset($record->orientation_name) ? $record->orientation_name:''; 
 $type              = ($id == '')   ? 'Create':'Update';
 
 ?>
 <main class="app-wrapper">
            <div class="container-fluid">

                <div class="d-flex align-items-center mt-2 mb-2">
                    
                    <div class="flex-shrink-0">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-end mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0)">Orientation</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?= $type ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-12 col-xxl-12">
                        <form method="POST" id="countryForm" action="<?= route('storeUpdateOrientation') ?>" enctype="multipart/form-data">
                           @csrf
                            <div>
                                <div class="card">
                                    <span></span>
                                    <!-- Logistics Details Section -->
                                    <div class="card-header">
                                        <h5 class="mb-0"><?= $type ?> Orientation</h5>
                                        <div class="float-end">
                                            <a href="<?=  route('orientation') ?>" class="btn btn-primary" >Back</a>
                                        </div>
                                    </div>
                                    <input type="hidden" name="id" value="<?= $id ?>" />
                                    <div class="card-body">
                                        <div class="row g-4">
                                            <div class="col-xl-4">
                                                <label for="orientation_name" class="form-label">Orientation Name <span class="text-danger"> *</span></label>
                                                <input type="text" value="<?= $orientation_name ?>"  class="form-control" id="orientation_name" name="orientation_name" placeholder="Enter Orientation Name">
                                                 @error('orientation_name') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>
                                           
                                        </div>

                                    </div>
                                </div>                               
                            </div>
                            <div class="d-flex justify-content-end gap-3 my-5">
                                <a href="" class="btn btn-light-light text-muted">Cancel</a>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                   
                </div>
                <!-- Submit Section -->
            </div>
        </main>
    <script>
        $(function() {
       $("#countryForm").validate({
         rules: {
           orientation_name: {  required: true },
        
         },
         messages: {
           orientation_name: { required: "Please enter Orientation Name" },          
         },
         errorElement: "span",
         errorPlacement: function(error, element) {
           error.addClass("text-danger");
           error.insertAfter(element);
         }
       });
     });
    </script>    
@endsection