 @extends('backend.app_template')
@section('title','Type Store or Update')
@section('content')
 <?php 
 $id                = isset($record->id) ? $record->id:'';
 $type              = isset($record->type) ? $record->type:''; 
 $type              = ($id == '')   ? 'Create':'Update';
 
 ?>
 <main class="app-wrapper">
            <div class="container-fluid">

                <div class="d-flex align-items-center mt-2 mb-2">
                    
                    <div class="flex-shrink-0">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-end mb-0">
                                <li class="breadcrumb-item"><a href="javascript:void(0)">Type</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?= $type ?></li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-12 col-xxl-12">
                        <form method="POST" id="countryForm" action="<?= route('storeUpdateType') ?>" enctype="multipart/form-data">
                           @csrf
                            <div>
                                <div class="card">
                                    <span></span>
                                    <!-- Logistics Details Section -->
                                    <div class="card-header">
                                        <h5 class="mb-0"><?= $type ?> Type</h5>
                                        <div class="float-end">
                                            <a href="<?=  route('type') ?>" class="btn btn-primary" >Back</a>
                                        </div>
                                    </div>
                                    <input type="hidden" name="id" value="<?= $id ?>" />
                                    <div class="card-body">
                                        <div class="row g-4">
                                            <div class="col-xl-4">
                                                <label for="type" class="form-label">Eye Color<span class="text-danger"> *</span></label>
                                                <input type="text" value="<?= $type ?>"  class="form-control" id="type" name="type" placeholder="Enter Type">
                                                 @error('type') <span class="text-danger">{{$message}}</span> @enderror
                                            </div>
                                           
                                        </div>

                                    </div>
                                </div>                               
                            </div>
                            <div class="d-flex justify-content-end gap-3 my-5">
                                <a href="" class="btn btn-light-light text-muted">Cancel</a>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                   
                </div>
                <!-- Submit Section -->
            </div>
        </main>
    <script>
        $(function() {
       $("#countryForm").validate({
         rules: {
           type: {  required: true },
        
         },
         messages: {
           type: { required: "Please enter type" },          
         },
         errorElement: "span",
         errorPlacement: function(error, element) {
           error.addClass("text-danger");
           error.insertAfter(element);
         }
       });
     });
    </script>    
@endsection