<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\ProductIndustryModel;
use Illuminate\Http\Request;

class IndustryController extends Controller
{
     public function industry()
    {
        $records   =  ProductIndustryModel::orderBy('id', 'ASC')->get();
        return view('backend.industry.list', compact('records'));
    }

    public function addIndustry($id = '')
    {
        $record = '';
        if ($id > 0) {
            $record = ProductIndustryModel::WHere('id', $id)->first();
        }
        return view('backend.industry.add_edit', compact('record'));
    }

    public function storeUpdateIndustry(Request $request)
    {
        $input     = $request->all();
        $id        = isset($input['id']) ? $input['id'] : 0;

        $dataArr = [];
        foreach ($input as $key => $val) {
            if ($key != '_token' && $key != 'id' )
                $dataArr[$key] = $val;
        }

       
        if ($id == 0 || $id == '') {
            $request->validate([
                'industry'          =>  "required|unique:industry,industry",
              
            ]);
           $insert = ProductIndustryModel::create($dataArr);
           if($insert['id'] > 0)
           {
               return redirect()->route('industry')->with('success', 'Industry Saved Successfully');
           }else{
               return redirect()->route('industry')->with('error', 'Something went wrong!');
           }
           
        } else {
            $request->validate([
                'industry'          =>  "required",               
            ]);
            $update = ProductIndustryModel::Where('id',$id)->update($dataArr);
            return redirect()->route('industry')->with('success', 'Industry Updated Successfully');;
        }        
    }
}
