<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Advertisement;
use App\Models\Support;
use App\Models\User;
use App\Models\WebRequestModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function dashboard()
    {
        $reqCont = WebRequestModel::count();
        $data = WebRequestModel::query()
                ->leftJoin('manage_request as mr', 'mr.request_id', '=', 'web_request.request_id')
                ->selectRaw("
                    COUNT(CASE WHEN mr.type = 1 THEN 1 END) as accept,
                    COUNT(CASE WHEN mr.type = 2 THEN 1 END) as decline
                ")->first();
        $adCount = Advertisement::count();

        $support = Support::query()
                ->selectRaw("
                            COUNT(id) as total,
                            COUNT(CASE WHEN status = 1 THEN 1 END) as review,
                            COUNT(CASE WHEN status = 2 THEN 1 END) as resolve
                        ")->first();

        
        $vendorCount = User::Where('auth_level',2)->count();

        $monthChart = WebRequestModel::from('web_request')
                        ->select(
                            DB::raw('COUNT(*) as cont'),                            
                            DB::raw('MONTHNAME(created_at) as month')
                        )
                        ->groupBy(DB::raw('MONTH(created_at)'))
                        ->orderBy(DB::raw('MONTH(created_at)'))
                        ->get();
        $adChart = Advertisement::from('advertisement')
                        ->select(
                            DB::raw('COUNT(*) as cont'),                            
                            DB::raw('MONTHNAME(created_at) as month')
                        )
                        ->groupBy(DB::raw('MONTH(created_at)'))
                        ->orderBy(DB::raw('MONTH(created_at)'))
                        ->get();

        $usersChart = User::from('users')
                        ->select(
                            DB::raw('COUNT(*) as cont'),                            
                            DB::raw('MONTHNAME(created_at) as month')
                        )
                        ->Where('auth_level',2)
                        ->groupBy(DB::raw('MONTH(created_at)'))
                        ->orderBy(DB::raw('MONTH(created_at)'))
                        ->get();

         $pieChart = WebRequestModel::from('web_request as wr')
                        ->leftJoin('service_type as st','st.id','=','wr.service_type')
                        ->select(
                            DB::raw('COUNT(wr.service_type) as cont'),                            
                            'st.service_type'
                        )
                        ->groupBy('wr.service_type')                       
                        ->get();
         $locationChart = WebRequestModel::from('web_request as wr')                        
                        ->select(
                            DB::raw('COUNT(wr.location) as cont'),                            
                            'wr.location')
                        ->WhereNotNull('wr.location')
                        ->groupBy('wr.location')                       
                        ->get();
       
        return view('backend.dashboard',compact('adChart','usersChart','support','vendorCount','adCount','locationChart','data','reqCont','monthChart','pieChart'));
    }

    public function blank()
    {
        return view('backend.blank');
    }
    
}
