@extends('backend.app_template')
@section('title','Slider List')
@section('content')
<main class="app-wrapper">
    <div class="container-fluid">

        <div class="d-flex align-items-center mt-2 mb-2">
            <div class="flex-shrink-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-end mb-0">
                        <li class="breadcrumb-item"><a href="javascript:void(0)">Slider</a></li>
                        <li class="breadcrumb-item active" aria-current="page">List</li>
                    </ol>
                </nav>
                
            </div>

        </div>

        <div class="row">
            <div class="d-flex justify-content-end mb-4">
                <a href="<?php echo route('addSlider') ?>" class="btn btn-primary">Add Slider</a>
            </div>
           
            <table id="datatables" class="table table-nowrap table-hover table-bordered w-100 mt-5">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Slider Name</th>
                        <th>Code</th>
                        <th>Flag</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (isset($records)) {
                        $i = 1;
                        foreach ($records as $key => $row) {
                    ?>
                            <tr>
                                <td><?php echo $i ?></td>
                                <td><?php echo $row->slider_caption ?></td>
                                <td><?php echo $row->slider_type ?></td>
                                <td>
                                    <?php if($row->slider_img != ''){ ?>
                                        <img src="<?=  $row->slider_img  ?>" width="30" />
                                    <?php } ?>
                                </td>
                                <td><a data-placement="top" title="Status" data-original-title="Status" href="javascript:void(0)" onclick="changeStatus('<?php echo $row->id ?>','<?php echo ($row->status == 1) ? 0 : 1 ?>','SliderModel')" class="badge bg-pill bg-<?php echo ($row->status == 1) ? 'success' : 'danger' ?>"><?php echo ($row->status == 1) ? 'Active' : 'In-Active' ?></a></td>
                                <td>
                                    <a data-toggle="tooltip" data-placement="top" title="Edit" href="<?php echo route('addModel', [$row->id]) ?>" class="btn btn-sm btn-warning"><i class="bi bi-pencil-fill"></i></a>
                                    <a data-toggle="tooltip" data-placement="top" title="Delete" data-original-title="Delete" href="javascript:void(0)" onclick="commonDelete('<?php echo $row->id ?>','SliderModel')" class="btn btn-sm btn-danger"><i class="bi bi-trash-fill"></i></a>
                                </td>
                            </tr>

                    <?php $i++;
                        }
                    } ?>

                </tbody>
            </table>
        </div>
        <!-- Submit Section -->
    </div>
</main>
@endsection