@extends('app_layout')
@section('title','Contact Us')
@section('content')
<main class="main">
    <div class="page-title ">
        <div class="container">
            <div class="row g-4">
                <h1 class="hfive text-center">Products</h1>
                <div class="col-lg-4">
                    <div class="accordion filter-accordion" id="filterAccordion">

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#type"
                                    aria-expanded="true">
                                    FILTER BY PRODUCT TYPE
                                </button>
                            </h2>
                            <div id="type" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <?php if (isset($productType)) {
                                        foreach ($productType as $row) { ?>
                                            <div><?= $row->type ?></div>
                                    <?php  }
                                    } ?>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#industry"
                                    aria-expanded="true">
                                    FILTER BY INDUSTRY
                                </button>
                            </h2>
                            <div id="industry" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <?php if (isset($industryData)) {
                                        foreach ($industryData as $row) { ?>
                                            <div><?= $row->industry ?></div>
                                    <?php  }
                                    } ?>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#brand"
                                    aria-expanded="true">
                                    FILTER BY BRAND
                                </button>
                            </h2>
                            <div id="brand" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <?php if (isset($brandData)) {
                                        foreach ($brandData as $row) { ?>
                                            <div><?= $row->brand ?></div>
                                    <?php  }
                                    } ?>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
                <div class="col-lg-8">
                    <div class="container py-4">
                        <div class="row g-4" id="productList">
                           
                        </div>

                        <div class="text-center mt-4">
                            <button id="loadMore"
                                class="btn btn-outline-dark">
                                Load More
                            </button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {

            $('.filter-accordion .accordion-body div').on('click', function() {
                $(this)
                    .closest('.accordion-body')
                    .find('div')
                    .removeClass('active');
                $(this).addClass('active');

            });

        });


        let offset = 0;
const limit = 6;

function loadProducts(reset = false) {

    if (reset) {
        offset = 0;
        $('#productList').html('');
    }

    $.ajax({
        url: '<?= route('getProducts') ?>',
        type: 'GET',
        data: {
            offset: offset,
            limit: limit
        },
        success: function (data) {

            // if (data.length === 0) {
            //     $('#loadMore').hide();
            //     return;
            // }
            $('#productList').append(data);
            offset += limit;
        }
    });
}

// Initial Load
loadProducts();

// Load More Click
$('#loadMore').on('click', function () {
    loadProducts();
});
    </script>


    @endsection