<?php

namespace App\Http\Controllers;


use App\Http\Controllers\Controller;
use App\Models\BrandProduct;
use App\Models\CategoryModel;
use App\Models\Country;
use App\Models\Currency;
use App\Models\DistanceRequest;
use App\Models\IndustryProduct;
use App\Models\WebRequestModel;
use App\Models\LanguageModel;
use App\Models\ManageRequestModel;
use App\Models\PagesModel;
use App\Models\ProductAttributeModel;
use App\Models\ProductBrandModel;
use App\Models\ProductIndustryModel;
use App\Models\ProductModel;
use App\Models\ProductTypeModel;
use App\Models\Service;
use App\Models\ServiceTypeModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Settings;
use App\Models\SizeModel;
use App\Models\SizeProduct;
use App\Models\SliderModel;
use Google\Service\AdExchangeBuyer\Product;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class FrontendController extends Controller
{

    public function index(Request $request)
    {
        $slidersData = SliderModel::Where('status', 1)->get();
        return view('index', compact('slidersData'));
        // return view('maintain');
    }

    public function contact()
    {
        return view('contact');
    }

    public function products()
    {
        $productType = CategoryModel::Where('status', 1)->get();
        $brandData = ProductBrandModel::Where('status', 1)->get();
        $industryData = ProductIndustryModel::Where('status', 1)->get();
        return view('products', compact('productType', 'brandData', 'industryData'));
    }

    public function getProduct($name = '')
    {

        $product  = ProductModel::Where('product_slug', $name)->first();
        $id       = isset($product->id) ? $product->id : 0;

        if ($id != '') {
            $record = ProductModel::with('category')->Where('id', $id)->first();

            $brands   = BrandProduct::from('product_brand as pb')
                ->leftJoin('brand as b', 'b.id', '=', 'pb.brand_id')
                ->where('pb.product_id', $id)
                ->select('b.brand', 'b.id')
                ->get();
            $industrys = IndustryProduct::from('product_industry as pb')
                ->leftJoin('industry as b', 'b.id', '=', 'pb.industry_id')
                ->where('pb.product_id', $id)
                ->select('b.industry', 'b.id')
                ->get();
            $size      = SizeProduct::from('product_size as pb')
                ->leftJoin('size as b', 'b.id', '=', 'pb.size_id')
                ->where('pb.product_id', $id)
                ->select('b.size', 'b.id')
                ->get();

            $productItems = ProductAttributeModel::Where('product_id', $id)->get();

            return view('product_detail', compact('record', 'size', 'industrys', 'brands', 'productItems'));
        }

        //    $records = ProductModel::get();
        //    foreach($records as $row)
        //    {        
        //      ProductModel::Where('id',$row->id)->update(array('product_slug'=>Str::slug($row->product_name)));           
        //    }


    }

    public function getAjaxProducts(Request $request)
    {
        $offset      = $request->get('offset', 0);
        $limit       = $request->get('limit', 12);
        $categoryId  = $request->get('category');
        $brandId     = $request->get('brand');
        $industryId  = $request->get('industry');

        DB::enableQueryLog();
        $products = ProductModel::query()->from('products as p')
            ->leftJoin('product_attributes as pi', 'pi.product_id', '=', 'p.id')
            ->select(['p.id', 'p.product_name', 'pi.product_image']);
        // 🔹 Filter: Category
        if ($categoryId) {
            $products->where('p.category_id', $categoryId);
        }


        // Brand filter (pivot)
        if ($brandId) {
            $products->whereExists(function ($q) use ($brandId) {
                $q->select(DB::raw(1))
                    ->from('product_brand as pb')
                    ->whereColumn('pb.product_id', 'p.id')
                    ->where('pb.brand_id', $brandId);
            });
        }

        // Industry filter (pivot)
        if ($industryId) {
            $products->whereExists(function ($q) use ($industryId) {
                $q->select(DB::raw(1))
                    ->from('product_industry as pi2')
                    ->whereColumn('pi2.product_id', 'p.id')
                    ->where('pi2.industry_id', $industryId);
            });
        }

        $records = $products->offset($offset)
            ->limit($limit)->get();
        // $d = DB::getRawQueryLog();
        //dd($d);
        return view('ajax_products', compact('records', 'offset', 'limit'));
    }

    public function career()
    {
        return view('career');
    }

    public function privacy_policy()
    {
        $record = PagesModel::Where('type', 1)->first();
        $type = 1;
        return view('pages', compact('record', 'type'));
    }

    public function terms_condition()
    {
        $record = PagesModel::Where('type', 2)->first();
        $type = 2;
        return view('pages', compact('record', 'type'));
    }

    public function about()
    {
        return view('about');
    }

    public function vendor()
    {
        return view('vendor');
    }
}
