<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ExamController extends CI_Controller
{

    public function index()
    {
        $view_data[]='';
        $data = array(
            'title' => 'Exam',
            'page' => 'Exam',
            'content' => $this->load->view('exam/exam', $view_data, true),           
        );
        $this->load->view('base/base_template', $data);
    }

    public function viewExam()
    {
        $view_data['records']=$this->getExamQuestions();
        $data = array(
            'title' => 'View Exam',
            'page' => 'View Exam',
            'content' => $this->load->view('exam/view_exam', $view_data, true),           
        );
        $this->load->view('base/base_template', $data);
    }

    public function getExamQuestions()
    {
        $this->db->select('y.year, es.academic, es.exam_schedule, es.date, es.time, es.id,et.exam_type_name as name');
        $this->db->from('question as q');
        $this->db->join('exam_schedule as es', 'es.id = q.schedule_id', 'left');
        $this->db->join('accadamic_year as y', 'y.id = q.academic', 'left');
        $this->db->join('exam_type as et', 'et.id = q.exam_type', 'left');
        $this->db->where('es.status', 1);
        $this->db->group_by('q.schedule_id');
        $query = $this->db->get();
        return $result = $query->result();        

    }

}

?>