<style>
:root {
    --color-blue: #1777E5;
    --color-blue-light: #D7E8FC;
    --color-blue-ultra-light: #EDF4FC;
    --color-dark-grey: #46494D;
    --color-border: #C2D8F2;
    --color-red-light: #F2DDDA;
    --color-red: #E0351B;

    --container-width: 1080px;
    --form-control-height: 50px;

    --base-font: 'Roboto', sans-serif;
}

.eye {
    width: 13px;
    height: 13px;
    border: solid 1px #1777e5;
    border-radius: 75% 15%;
    transform: rotate(45deg);
    opacity: .75;
    position: absolute;
    top: 11px;
    right: 13px;
    cursor: pointer;
    z-index: 200;
}

.eye.closed {
    background: #1777e5;
    opacity: .5;
}

.eye:before {
    content: '';
    display: block;
    position: absolute;
    width: 5px;
    height: 5px;
    border: solid 1px #1777e5;
    border-radius: 50%;
    left: 3px;
    top: 3px;
}

.form-control {
    background-color: #fff;
    /* min-height: var(--form-control-height); */
    color: var(--color-dark-grey);
    /* border: 1px solid var(--color-border);
        border-radius: 5px;
        font-size: 15px;
        padding: 12px 20px; */
    font-family: var(--base-font);
    box-sizing: border-box;
}

.control {
    position: relative;
}

button.form-control {
    background: royalblue;
    color: #fff;
}

.rez {
    width: 200px;
    margin: 10px 0;
}
</style>
<div class="row align-items-center">
    <div class="col-sm-6">
        <div class="page-title-box">
            <h4 class="font-size-18">User Management</h4>
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="javascript: void(0);">Users</a></li>
                <li class="breadcrumb-item active">Manage Users</li>
            </ol>
        </div>
    </div>

    <div class="col-sm-6">
        <div class="float-right d-none d-md-block">

            <a class="btn btn-primary waves-effect waves-light" href="<?php echo base_url(); ?>users/manage_users/">
                <i class="mdi mdi-plus mr-2"></i> View Users
            </a>
        </div>
    </div>
</div>

<?php
if ($this->session->flashdata('alert_success')) {
    ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
    <strong>Success!</strong> <?php echo $this->session->flashdata('alert_success'); ?>
</div>
<?php
}

if ($this->session->flashdata('alert_danger')) {
    ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
    <strong>Success!</strong> <?php echo $this->session->flashdata('alert_danger'); ?>
</div>
<?php
}

if ($this->session->flashdata('alert_warning')) {
    ?>
<div class="alert alert-warning alert-dismissible fade show" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
    <strong>Success!</strong> <?php echo $this->session->flashdata('alert_warning'); ?>
</div>
<?php
}
if (validation_errors()) {
    ?>
<!-- <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">×</span>
        </button>
        <?php echo validation_errors(); ?>
    </div> -->
<?php
}
?>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Edit <?php echo $default['username']; ?></h4>

                <form action="<?php echo base_url(); ?>users/manage_users/edit/<?php echo $default['user_id']; ?>"
                    method="post" enctype="multipart/form-data">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>First Name</label><span class="mandatory">*</span>
                                <input name="first_name" id="first_name" type="text" class="form-control"
                                    placeholder="Enter First Name" value="<?php echo $default['first_name']; ?>">
                                <?php if (form_error('first_name')) {?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                    <?php echo form_error('first_name'); ?>
                                </div>
                                <?php }?>
                            </div>
                            <div class="form-group">
                                <label>Email Address</label>
                                <input name="email" id="email" type="email" class="form-control"
                                    placeholder="Enter Email (optional)" value="<?php echo $default['email']; ?>">
                                <?php if (form_error('email')) {?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                    <?php echo form_error('email'); ?>
                                </div>
                                <?php }?>
                            </div>
                            <div class="form-group">
                                <label>Password</label><span class="mandatory">*</span>
                                <div class="control">
                                    <input name="password" id="password" type="password" class="form-control"
                                        placeholder="Enter Password"
                                        value="<?php echo (isset($_POST['password']))?$_POST['password']:''; ?>">
                                    <i class="eye showPwd1"></i>
                                </div>
                                <?php if (form_error('password')) {?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                    <?php echo form_error('password'); ?>
                                </div>
                                <?php }?>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Last Name</label><span class="mandatory">*</span>
                                <input name="last_name" id="last_name" type="text" class="form-control"
                                    placeholder="Enter last Name" value="<?php echo $default['last_name']; ?>">
                                <?php if (form_error('last_name')) {?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                    <?php echo form_error('last_name'); ?>
                                </div>
                                <?php }?>
                            </div>
                            <div class="form-group">
                                <label>Mobile Number</label><span class="mandatory">*</span>
                                <input name="mobile_number" id="mobile_number" type="number" class="form-control"
                                    placeholder="Enter Mobile Number" value="<?php echo $default['mobile']; ?>"
                                    onkeyup="check();">
                                <?php if (form_error('mobile_number')) {?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                    <?php echo form_error('mobile_number'); ?>
                                </div>
                                <?php }?>
                            </div>
                            <div class="form-group">
                                <label>Confirm Password</label><span class="mandatory">*</span>
                                <div class="control">
                                    <input name="confirm_password" id="confirm_password" type="password"
                                        class="form-control" placeholder="Confirm Password"
                                        value="<?php echo (isset($_POST['confirm_password']))?$_POST['confirm_password']:''; ?>">
                                    <i class="eye showPwd"></i>
                                </div>
                                <?php if (form_error('confirm_password')) {?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                    <?php echo form_error('confirm_password'); ?>
                                </div>
                                <?php }?>
                            </div>

                        </div>
                    </div>
                    <input name="old_image" id="old_image" type="hidden" class="form-control"
                        value="<?php echo $default['profile_pic']; ?>">
                    <div class="form-group mb-0">
                        <div>
                            <button name="submit" type="submit" class="btn btn-primary waves-effect waves-light mr-1">
                                Submit
                            </button>
                            <button type="reset" class="btn btn-secondary waves-effect" onclick="window.history.back()">
                                Cancel
                            </button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    var zone_id = "<?php echo $default['zone'];?>";
    // var role_id = "<?php echo $default['role'];?>";       
    get_region(zone_id);

});
let pwd = document.getElementById('confirm_password'),
    eye = document.querySelector('.showPwd'),
    rez = document.querySelector('.rez'),
    btn = document.querySelector('button');

eye.addEventListener('click', function() {
    toggleType();
})

pwd.addEventListener('change', function() {
    pwd.value = pwd.value.replace(/\s/g, '');
})
btn.addEventListener('click', function() {
    console.log('clk');
    rez.innerText = '_' + pwd.value + '_';
})

console.log(btn, rez, eye);

function toggleType() {
    console.log('toggle');
    if (eye.classList.contains('closed')) {
        pwd.type = 'password';
    } else {
        pwd.type = 'text';
    }
    eye.classList.toggle('closed');
}

let pwd1 = document.getElementById('password'),
    eye1 = document.querySelector('.showPwd1'),
    rez1 = document.querySelector('.rez'),
    btn1 = document.querySelector('button');
// alert(eye1);
eye1.addEventListener('click', function() {
    toggleType1();
})

pwd1.addEventListener('change', function() {
    pwd1.value = pwd1.value.replace(/\s/g, '');
})
btn1.addEventListener('click', function() {
    console.log('clk');
    rez1.innerText = '_' + pwd1.value + '_';
})

console.log(btn1, rez1, eye1);

function toggleType1() {
    console.log('toggle');
    if (eye1.classList.contains('closed')) {
        pwd1.type = 'password';
    } else {
        pwd1.type = 'text';
    }
    eye1.classList.toggle('closed');
}

function check() {

    var mobile = document.getElementById('mobile_number');


    var message = document.getElementById('message');

    var goodColor = "#0C6";
    var badColor = "#FF9B37";

    if (mobile.value.length != 10) {
        mobile.style.backgroundColor = badColor;
        message.style.color = badColor;
        message.innerHTML = "required 10 digits, match requested format!"
    } else {
        mobile.style.backgroundColor = goodColor;
        message.style.color = goodColor;
        message.innerHTML = ""
    }
}

function get_region(zone_id) {
    var region_id = "<?php echo $default['region'];?>";
    $.ajax({
        url: "<?php echo site_url() ?>/users/manage_users/get_region",
        method: "POST",
        type: "ajax",
        data: {
            zone_id: zone_id
        },
        success: function(result) {
            var data = JSON.parse(result);
            $('#region')
                .find('option')
                .remove();
            $("#region").prepend("<option value=''>Select</option>").val('');
            $.each(data, function(key, value) {
                var option = '<option value="' + value.region_id + '">' + value.region_name +
                    '</option>';
                $('#region').append(option);
            });
            $('#region').val(region_id);
        },
        error: function(error) {
            console.log(error);
        }
    });
}
</script>