<?php
defined('BASEPATH') or exit('No direct script access allowed');

class QuestionController extends CI_Controller
{
   
    public function viewQuestion()
    {
        
        $view_data['records'] =  $this->mcommon->records_all('question');
        $view_data['exam_type'] =  $this->mcommon->records_all('exam_type',array('status',1));
        $view_data['academic_year'] =  $this->mcommon->records_all('accadamic_year',array('status',1));
        $view_data['schedule'] =  $this->mcommon->records_all('exam_schedule',array('status',1));
        $view_data['category'] =  $this->mcommon->records_all('section_category',array('status',1));
        $data = array(
            'title' => 'View Question ',
            'page' => 'View Question',
            'content' => $this->load->view('questions/view', $view_data, true),
        );
        $this->load->view('base/base_template', $data);
    }
    public function questionAdd()
    {

        if(isset($_POST['submit'])){
          
            $academic = $this->input->post('academic');
            $exam_type = $this->input->post('exam_type');
            $category = $this->input->post('category');
            $schedule = $this->input->post('schedule');
            $question = $this->input->post('question');
            $option_a = $this->input->post('option_a');
            $option_b = $this->input->post('option_b');
            $option_c = $this->input->post('option_c');
            $option_d = $this->input->post('option_d');
            $answer = $this->input->post('answer');

            $insert_array = array(
                        'academic'          =>  $academic,
                        'exam_type'         =>  $exam_type,
                        'category'          =>  $category,
                        'schedule_id'          => $schedule,
                        'question'          =>  $question,
                        'option_a'          =>  $option_a,
                        'option_b'          =>  $option_b,
                        'option_c'          =>  $option_c,
                        'option_d'          =>  $option_d,
                        'answer'            =>  $answer,
                       
                    );
            
                    $insert = $this->mcommon->common_insert('question', $insert_array);
            
                    if ($insert) {
            
                        $this->session->set_flashdata('alert_success', 'Question  added successfully!');
                        redirect('QuestionController/viewQuestion');
                    
                    } else {
                        $this->session->set_flashdata('alert_danger', 'Error in Add Question!');
                    }

        }else{

            $view_data['exam_type'] =  $this->mcommon->records_all('exam_type',array('status',1));
            $view_data['academic_year'] =  $this->mcommon->records_all('accadamic_year',array('status',1));
            $view_data['category'] =  $this->mcommon->records_all('section_category',array('status',1));
            $view_data['schedule'] =  $this->mcommon->records_all('exam_schedule',array('status',1));

            $data = array(
                'title' => 'Add  Question',
                'page' => 'Add  Question',
                'content' => $this->load->view('questions/add', $view_data, true),
            );
            $this->load->view('base/base_template', $data);
        }
            
        }

        public function questionEdit($id){
         
           
        if(isset($_POST['submit'])){

            $academic = $this->input->post('academic');
            $exam_type = $this->input->post('exam_type');
            $category = $this->input->post('category');
            $schedule = $this->input->post('schedule');
            $question = $this->input->post('question');
            $option_a = $this->input->post('option_a');
            $option_b = $this->input->post('option_b');
            $option_c = $this->input->post('option_c');
            $option_d = $this->input->post('option_d');
            $answer = $this->input->post('answer');

            $update_array = array(

                        'academic'          =>  $academic,
                        'exam_type'         =>  $exam_type,
                        'category'          =>  $category,
                        'schedule_id'       =>  $schedule,
                        'question'          =>  $question,
                        'option_a'          =>  $option_a,
                        'option_b'          =>  $option_b,
                        'option_c'          =>  $option_c,
                        'option_d'          =>  $option_d,
                        'answer'            =>  $answer,
                    );
                  
                    $update = $this->mcommon->common_edit('question',$update_array,array('id' => $id));
            
                    if ($update) {
            
                        $this->session->set_flashdata('alert_success', 'Question  Updated successfully!');
                        redirect('QuestionController/viewQuestion');
                    
                    } else {
                        $this->session->set_flashdata('alert_danger', 'Error in Updated Question!');
                    }

        }else{

            $view_data['default'] = $this->mcommon->specific_row('question', array('id' => $id));
            $view_data['exam_type'] =  $this->mcommon->records_all('exam_type',array('status',1));
            $view_data['academic_year'] =  $this->mcommon->records_all('accadamic_year',array('status',1));
            $view_data['category'] =  $this->mcommon->records_all('section_category',array('status',1));
            $view_data['schedule'] =  $this->mcommon->records_all('exam_schedule',array('status',1));
            $data = array(
                'title' => 'Edit  Question',
                'page' => 'Edit  Question',
                'content' => $this->load->view('questions/edit', $view_data, true),
            );
            $this->load->view('base/base_template', $data);
        }

        }







        public function viewEssayQuestion()
        {
            
            $view_data['records'] =  $this->mcommon->records_all('question');
            $view_data['exam_type'] =  $this->mcommon->records_all('exam_type',array('status',1));
            $view_data['academic_year'] =  $this->mcommon->records_all('accadamic_year',array('status',1));
            $view_data['schedule'] =  $this->mcommon->records_all('exam_schedule',array('status',1));
            $view_data['category'] =  $this->mcommon->records_all('section_category',array('status',1));
            $data = array(
                'title' => 'View Question ',
                'page' => 'View Question',
                'content' => $this->load->view('essay_question/view', $view_data, true),
            );
            $this->load->view('base/base_template', $data);
        }
        public function essayquestionAdd()
        {
    
            if(isset($_POST['submit'])){
              
                $academic = $this->input->post('academic');
                $exam_type = $this->input->post('exam_type');
                $category = $this->input->post('category');
                $schedule = $this->input->post('schedule');
                $question = $this->input->post('question');
              
    
                $insert_array = array(
                            'academic'          =>  $academic,
                            'exam_type'         =>  $exam_type,
                            'category'          =>  $category,
                            'schedule_id'          => $schedule,
                            'question'          =>  $question,
                            
                           
                        );
                
                        $insert = $this->mcommon->common_insert('question', $insert_array);
                
                        if ($insert) {
                
                            $this->session->set_flashdata('alert_success', 'Question  added successfully!');
                            redirect('ApplicationController/viewQuestion');
                        
                        } else {
                            $this->session->set_flashdata('alert_danger', 'Error in Add Question!');
                        }
    
            }else{
    
                $view_data['exam_type'] =  $this->mcommon->records_all('exam_type',array('status',1));
                $view_data['academic_year'] =  $this->mcommon->records_all('accadamic_year',array('status',1));
                $view_data['category'] =  $this->mcommon->records_all('section_category',array('status',1));
                $view_data['schedule'] =  $this->mcommon->records_all('exam_schedule',array('status',1));
    
                $data = array(
                    'title' => 'Add  Question',
                    'page' => 'Add  Question',
                    'content' => $this->load->view('questions/add', $view_data, true),
                );
                $this->load->view('base/base_template', $data);
            }
                
            }
    
            public function essayquestionEdit($id){
             
               
            if(isset($_POST['submit'])){
    
                $academic = $this->input->post('academic');
                $exam_type = $this->input->post('exam_type');
                $category = $this->input->post('category');
                $schedule = $this->input->post('schedule');
                $question = $this->input->post('question');
                
    
                $update_array = array(
    
                            'academic'          =>  $academic,
                            'exam_type'         =>  $exam_type,
                            'category'          =>  $category,
                            'schedule_id'       =>  $schedule,
                            'question'          =>  $question,
                           
                        );
                      
                        $update = $this->mcommon->common_edit('question',$update_array,array('id' => $id));
                
                        if ($update) {
                
                            $this->session->set_flashdata('alert_success', 'Question  Updated successfully!');
                            redirect('ApplicationController/viewQuestion');
                        
                        } else {
                            $this->session->set_flashdata('alert_danger', 'Error in Updated Question!');
                        }
    
            }else{
    
                $view_data['default'] = $this->mcommon->specific_row('question', array('id' => $id));
                $view_data['exam_type'] =  $this->mcommon->records_all('exam_type',array('status',1));
                $view_data['academic_year'] =  $this->mcommon->records_all('accadamic_year',array('status',1));
                $view_data['category'] =  $this->mcommon->records_all('section_category',array('status',1));
                $view_data['schedule'] =  $this->mcommon->records_all('exam_schedule',array('status',1));
                $data = array(
                    'title' => 'Edit  Question',
                    'page' => 'Edit  Question',
                    'content' => $this->load->view('questions/edit', $view_data, true),
                );
                $this->load->view('base/base_template', $data);
            }
    
            }

        

     

}
