<?php
defined('BASEPATH') or exit('No direct script access allowed');

class AuthController extends CI_Controller
{

	public function index()
	{
		$view_data[''] = '';

		$this->load->view('auth/login', $view_data);
	}

	public function login()
	{
		
		$email = $this->input->post('email');
		$password = $this->input->post('password');


		$user = $this->mcommon->specific_row('users',array('email'=>$email));
		
		if ($user['user_id'] != '' && password_verify($password, $user['passwd'])) {
			
			$this->session->set_flashdata('alert_success', 'Login successfully!');
			$userArray = array(
				"user_id" => $user['user_id'],
				"email" => $user['email'],
				"mobile" => $user['mobile'],
				"name" => $user['name'],
				"auth_level" => $user['auth_level'],
				"logged_in" => true,
			);
			$this->session->set_userdata($userArray);
			redirect('DashboardController');
		} else {
			$this->session->set_flashdata('alert_danger', 'Email or Password Wrong!');
			redirect('login');
		}
	}

	// public function register()
	// {

	// 	if (isset($_POST['submit'])) {

			

	// 		$user_array = array(
	// 			'first_name' => $first_name,
	// 			// 'last_name' => $last_name,
	// 			'username' => $username,
	// 			'name' => $name,
	// 			'email' => $email,
	// 			'mobile' => $mobile_number,
	// 			'auth_level' => 1, // 1->customer,9->admin
	// 			'passwd' => password_hash($password, PASSWORD_DEFAULT),
	// 			'created_at' => date("Y-m-d h:i:s"),
	// 			'banned' => 0
	// 		);
	// 		//insert values in database
	// 		$insert = $this->mcommon->common_insert('users', $user_array);
	// 	} else {
	// 		$view_data[''] = '';
	// 		$this->load->view('auth/register', $view_data);
	// 	}
	// }

	public function forget()
	{
		$view_data[''] = '';

		$this->load->view('auth/forget', $view_data);
	}

	public function logout()
    {

        $this->session->unset_userdata('logged_in');
        $this->session->sess_destroy();
		redirect(base_url());
    }

}
