<?php
defined('BASEPATH') or exit('No direct script access allowed');

class DashboardController extends CI_Controller
{

	public function index()
	{

		$this->db->from('applications');
		$this->db->where('payment_status', 0);
		$drafted = $this->db->count_all_results();

		$this->db->from('applications');
		$this->db->where('payment_status', 1);
		$pending = $this->db->count_all_results();

		$this->db->from('applications');
		$this->db->where('payment_status', 2);
		$completed = $this->db->count_all_results();


		$currentYear = date('Y');

		$this->db->select('MONTH(a.created_at) as month, COUNT(*) as count');
		$this->db->from('applications as a');
		$this->db->join('accomodation_info as ai', 'ai.application_id = a.id', 'left');
		$this->db->where('a.status', 1);
		$this->db->where('YEAR(a.created_at)', $currentYear); // Ensure filtering by the same date field used for grouping
		$this->db->group_by('MONTH(a.created_at)');
		$query = $this->db->get();
		

		$monthlyCounts = array_fill(0, 12, 0); // Start indices from 0 to 11 for months Jan-Dec
		
		foreach ($query->result() as $row) {
			$monthlyCounts[$row->month - 1] = (int) $row->count; // Adjust index by 1 to match array indexing
		}
		
		$view_data['monthlyCounts'] = $monthlyCounts;
		
		// print_r($view_data['monthlyCounts']);
		// exit;

		$this->db->from('applications as a');
		$this->db->where('a.payment_status', 2);
		$completed_count = $this->db->count_all_results();
		$total_amount = $completed_count * 1260;


		$view_data['courses'] = $this->mcommon->records_all('course');

        $this->db->select('*, applications.id as appid, applications.status as apstatus,ai.payment_mode,applications.email as appEmail');
        $this->db->from('applications');
        $this->db->join('course', 'course.id = applications.course_id', 'left');
        $this->db->join('users', 'users.user_id = applications.user_id','left');
        $this->db->join('accomodation_info as ai', 'ai.application_id = applications.id','left');
        $this->db->join('application_other_info as athinfo', 'athinfo.application_id = applications.id','left');
        // $this->db->where('athinfo.tab_status', '1');
        $this->db->where('applications.status', '1');
        $query = $this->db->get();

        $view_data['records'] = $query->result();


		$view_data['drafted'] = $drafted;
		$view_data['pending'] = $pending;
		$view_data['completed'] = $completed;
		$view_data['total_amount'] = $total_amount;

		$data = array(
			'title' => "Home",
			'content' => $this->load->view('dashboard/home', $view_data, true),
		);
		$this->load->view('base/base_template', $data);
	}
}
