<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ExamController extends CI_Controller
{

    public function index()
    {
        $view_data[]='';
        $data = array(
            'title' => 'Exam',
            'page' => 'Exam',
            'content' => $this->load->view('exam/exam', $view_data, true),           
        );
        $this->load->view('base/base_template', $data);
    }

    public function viewExam()
    {
        $view_data['records']=$this->getExamQuestions();
        $data = array(
            'title' => 'View Exam',
            'page' => 'View Exam',
            'content' => $this->load->view('exam/view_exam', $view_data, true),           
        );
        $this->load->view('base/base_template', $data);
    }

    public function getExamQuestions()
    {
        $this->db->select('y.year, es.academic,u.email,es.id as sid,ea.question_category,ea.user_id,es.exam_schedule, es.objective_date, es.objective_time, es.id,et.exam_type_name as name');
        $this->db->from('question as q');
        $this->db->join('exam_schedule as es', 'es.id = q.schedule_id', 'left');
        $this->db->join('accadamic_year as y', 'y.id = q.academic', 'left');
        $this->db->join('exam_type as et', 'et.id = q.exam_type', 'left');
        $this->db->join('exam_assigned as ea', 'ea.schedule = q.schedule_id', 'left');
        $this->db->join('users as u', 'u.user_id = ea.user_id', 'left');
        $this->db->where('es.status', 1);
        $this->db->group_by('q.schedule_id,ea.user_id');
        $query = $this->db->get();
        return $result = $query->result(); 
    }

    public function takeExam($user,$sid,$cat)
    {
        $view_data['questions']=$this->mcommon->getExamQuestions($cat);       
        $authId = 1;
        date_default_timezone_set('Asia/Calcutta'); 
        $date = date('Y-m-d h:i:s',strtotime("+40 minutes"));
        $time = date('h:i:s',strtotime("+40 minutes"));
        $view_data['time'] = $time;
        $view_data['date'] = $date;
        $view_data['userData'] = array(
            'userId' => $user,
            'categoryId' => $cat,
            "schedule"=> $sid
        );

      $examId = $this->mcommon->specific_row_value('exam_assigned',array("user_id"=>$user,"schedule"=>$sid,"question_category"=>$cat),"id");
      
       if($examId != null && $examId > 0 && $examId != '')
       {
          $updateArray = array('is_attend' => 1,'start_date'=>date('Y-m-d h:i:s'),'end_date'=>$date);
          $this->mcommon->common_edit('exam_assigned',$updateArray,array('id'=>$examId));
       }

        $data = array(
            'title' => 'View Exam',
            'page' => 'View Exam',
            'content' => $this->load->view('exam/exam', $view_data, true),           
        );
        $this->load->view('base/base_template', $data);
    }

    public function storeExam()
    {
        $userId       =      $this->input->post('user_id');
        $schedule_id  =  $this->input->post('schedule_id');
        $category_id  =  $this->input->post('category_id');
        $question     =  $this->input->post('question');
        $questions    =  $this->input->post('questions');
        $org       =  $this->input->post('org_ques');
        $examId = $this->mcommon->specific_row_value('exam_assigned',array("user_id"=>$userId,"schedule"=>$schedule_id,"question_category"=>$category_id),"id");
        if($examId != null && $examId > 0 && $examId != '')
        {
            foreach($question as $key=>$val)
            {
                $insertArr = array(
                    'exam_id' => $examId,
                    'question_id' => $val,
                    'org_answer'  =>$org[$key],
                    'user_id' => $userId,
                    'schedule_id' => $schedule_id,
                    'category_id' => $category_id,
                    'answers' => $questions[$val]
                );
                $this->mcommon->common_insert('exam_attend',$insertArr);
            }
            redirect('ExamController/viewExam');
        }
      
    
    }

}

?>