

<?php
if ($this->session->flashdata('alert_success')) {
    ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
    <strong>Success!</strong> <?php echo $this->session->flashdata('alert_success'); ?>
</div>
<?php
}

if ($this->session->flashdata('alert_danger')) {
    ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
    <strong>Success!</strong> <?php echo $this->session->flashdata('alert_danger'); ?>
</div>
<?php
}

if ($this->session->flashdata('alert_warning')) {
    ?>
<div class="alert alert-warning alert-dismissible fade show" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">×</span>
    </button>
    <strong>Success!</strong> <?php echo $this->session->flashdata('alert_warning'); ?>
</div>
<?php
}
if (validation_errors()) {
    ?>
<!-- <div class="alert alert-danger alert-dismissible fade show" role="alert">
<button type="button" class="close" data-dismiss="alert" aria-label="Close">
<span aria-hidden="true">×</span>
</button>
<?php echo validation_errors(); ?>
</div> -->
<?php
}
?>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo $actionUrl; ?>" method="post" enctype="multipart/form-data">
                    <h3 id="Title"></h3>
                    <div class="row">
                        <div class="col-md-6 form-group">
                            <label>Financial Year</label><span class="mandatory">*</span>
                            <input type="hidden" name="id" id="year_id" />
                            <input name="year" id="year" type="text" class="form-control" placeholder="2023-2024"
                                required>
                            <?php if (form_error('year')) {?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                                <?php echo form_error('year'); ?>
                            </div>
                            <?php }?>
                        </div>

                        <div class="col-md-6 form-group">
                            <label>Status</label><span class="mandatory">*</span>
                            <select name="status" id="statuss" class="form-control select2" required>
                                <option value="">Select Status</option>
                                <option value="1">Active</option>
                                <option value="0">In-Active</option>
                            </select>
                            <?php if (form_error('Status')) {?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                                <?php echo form_error('Status'); ?>
                            </div>
                            <?php }?>
                        </div>
                    </div>



                    <div class="form-group mb-0">
                        <div>
                            <button name="submit" type="submit" id="save" class="btn btn-primary waves-effect waves-light mr-1">
                                Submit
                            </button>
                            <button type="reset" class="btn btn-secondary waves-effect"
                                onclick="window.location.reload()">
                                Cancel
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <!-- <button type="button" class="btn btn-info btn-sm" id="excel" onclick="exportReportToExcel(this)">Export to Excel</button>  -->
                <table id="dmstable" class="table table-striped table-bordered dt-responsive nowrap"
                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Year</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($records)){ 
                        $i=1;
                        foreach($records as $row){  
                    ?>
                        <tr>
                            <td><?= $i ?></td>
                            <td><?= $row->year ?></td>
                            <td><a href="javascript:void(0)"
                                    class="badge badge-<?= ($row->status==1) ? 'success':'danger' ?>"><?= ($row->status==1) ? 'Active':'In-Active' ?></a>
                            </td>
                            <td><a href="javascript:editYear('<?= $row->id ?>')" class="btn-sm btn-info"><i class="ti-pencil-alt"></i></a>
                                <a href="javascript:deleteYear('<?= $row->id ?>')" class="btn-sm btn-danger"><i class="ti-trash"></i></a>
                            </td>
                        </tr>
                        <?php  $i++; } }?>

                    </tbody>
                </table>
                <?php
       // if (empty($result)) {?>
                <!-- <tr>
                <h4 style="text-align:center;">NO RESULT FOUND</h4>
            </tr> -->
                <?php // }
        ?>
            </div>
        </div>
    </div>
</div>


<script>

function editYear(id) {
    $.ajax({
        url: "<?php echo site_url() ?>/settingsController/getYearData/" + id,
        method: "GET",
        success: function(result) {
            var data = JSON.parse(result);
            if (data.length > 0) {
                $('#year_id').val(data[0].id);
                $('#statuss').val(data[0].status);
                $('#year').val(data[0].year);
                $('#Title').text("Edit Financial year");
                $('#save').text("Submit & Save");
                document.documentElement.scrollTop = 0;
            }
        },
        error: function(error) {
            console.log(error);
        }
    });
}

function deleteYear(id) {
    if (confirm("Do you really want to delete?") === true) {
        $.ajax({
            url: "<?php echo site_url() ?>/settingsController/deleteYear/" + id,
            method: "GET",
            success: function(result) {
                if (result > 0) {
                    window.location.reload();
                }
            },
            error: function(error) {
                console.log(error);
            }
        });
    }
}

$('#dmstable').DataTable();

function get_region(zone_id) {
    $.ajax({
        url: "<?php echo site_url() ?>/users/manage_dealers/get_region",
        method: "POST",
        type: "ajax",
        data: {
            zone_id: zone_id
        },
        success: function(result) {
            var data = JSON.parse(result);
            $('#region')
                .find('option')
                .remove();
            $.each(data, function(key, value) {
                var option = '<option value="' + value.region_id + '">' + value.region_name +
                    '</option>';
                $('#region').append(option);
            });
        },
        error: function(error) {
            console.log(error);
        }
    });
}
</script>